/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.proxy;

import binnie.core.AbstractMod;
import binnie.core.network.BinnieCorePacketID;
import binnie.core.network.INetworkedEntity;
import binnie.core.network.packet.MessageUpdate;
import binnie.core.proxy.BinnieModProxy;
import binnie.core.proxy.IBinnieProxy;
import binnie.core.resource.BinnieResource;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;

public abstract class BinnieProxy
extends BinnieModProxy
implements IBinnieProxy {
    private short uniqueTextureUID = (short)1200;

    public boolean checkTexture(BinnieResource location) {
        return false;
    }

    @Override
    public void openGui(AbstractMod mod, int id, EntityPlayer player, BlockPos pos) {
        player.openGui(mod.getMod(), id, player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public TextureAtlasSprite getTextureAtlasSprite(ResourceLocation location) {
        throw new UnsupportedOperationException("Cannot call getTextureAtlasSprite on server side");
    }

    @Override
    public boolean needsTagCompoundSynched(Item item) {
        return item.func_77651_p();
    }

    @Override
    public World getWorld() {
        return this.getServer().func_130014_f_();
    }

    @Override
    public Minecraft getMinecraftInstance() {
        throw new UnsupportedOperationException("Cannot call getMinecraftInstance on server side");
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public File getDirectory() {
        return new File("./");
    }

    @Override
    public void registerTileEntity(Class<? extends TileEntity> tile, String id, @Nullable Object renderer) {
        this.registerTileEntity(tile, id);
    }

    @Override
    public void registerTileEntity(Class<? extends TileEntity> tile, String id) {
        GameRegistry.registerTileEntity(tile, (String)id);
    }

    public void sendNetworkEntityPacket(INetworkedEntity entity) {
        MessageUpdate packet = new MessageUpdate(BinnieCorePacketID.NETWORK_ENTITY_UPDATE.ordinal(), entity);
        this.sendToAll(packet);
    }

    public void registerSprite(ResourceLocation location) {
    }

    public short getUniqueTextureUID() {
        short uniqueTextureUID = this.uniqueTextureUID;
        this.uniqueTextureUID = (short)(uniqueTextureUID + 1);
        return uniqueTextureUID;
    }

    @Override
    public void bindTexture(ResourceLocation location) {
    }

    public void reloadSprites() {
    }

    public EntityPlayer getPlayer() {
        throw new UnsupportedOperationException("Cannot call getPlayer on server side");
    }

    public MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }
}

