/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft;

import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.events.EventKey;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.MinecraftTooltip;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.renderer.RenderUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiCraftGUI
extends GuiContainer {
    private Point mousePos = Point.ZERO;
    private Window window;
    private ItemStack draggedItem;

    public GuiCraftGUI(Window window) {
        super((Container)window.getContainer());
        this.window = window;
        this.draggedItem = ItemStack.field_190927_a;
        this.resize(window.getSize());
    }

    public void func_73876_c() {
        this.window.updateClient();
    }

    public Minecraft getMinecraft() {
        return this.field_146297_k;
    }

    protected void func_146976_a(float var1, int var2, int var3) {
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.window.setSize(new Point(this.field_146999_f, this.field_147000_g));
        this.window.setPosition(new Point(this.field_147003_i, this.field_147009_r));
        this.window.initGui();
    }

    public ItemStack getDraggedItem() {
        return this.draggedItem;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.window.setMousePosition(mouseX - this.window.getPosition().xPos(), mouseY - this.window.getPosition().yPos());
        this.func_146276_q_();
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.field_73735_i = 10.0f;
        this.window.render(this.field_146294_l, this.field_146295_m);
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        InventoryPlayer playerInventory = this.field_146297_k.field_71439_g.field_71071_by;
        this.draggedItem = playerInventory.func_70445_o();
        if (!this.draggedItem.func_190926_b()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            RenderUtil.drawItem(new Point(mouseX - 8, mouseY - 8), this.draggedItem, false);
        }
        RenderHelper.func_74520_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        if (this.draggedItem.func_190926_b()) {
            MinecraftTooltip tooltip = new MinecraftTooltip();
            if (this.isHelpMode()) {
                tooltip.setType(Tooltip.Type.HELP);
                this.window.getHelpTooltip(tooltip);
            } else {
                tooltip.setType(Tooltip.Type.STANDARD);
                ITooltipFlag.TooltipFlags tooltipFlag = this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
                this.window.getTooltip(tooltip, (ITooltipFlag)tooltipFlag);
            }
            if (tooltip.exists()) {
                this.renderTooltip(new Point(mouseX, mouseY), tooltip);
            }
        }
        this.field_73735_i = 0.0f;
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public void renderTooltip(Point mousePosition, MinecraftTooltip tooltip) {
        int mouseX = mousePosition.xPos();
        int mouseY = mousePosition.yPos();
        FontRenderer font = this.getFontRenderer();
        ItemStack itemStack = tooltip.getItemStack();
        boolean containsItemRender = false;
        ArrayList<String> textLines = new ArrayList<String>();
        for (String string : tooltip.getList()) {
            if (string == null) continue;
            if (!string.contains("~~~")) {
                textLines.addAll(font.func_78271_c(string, tooltip.maxWidth));
                continue;
            }
            textLines.add(string);
            containsItemRender = true;
        }
        int tooltipTextWidth = 0;
        for (String textLine : textLines) {
            int textLineWidth = font.func_78256_a(textLine);
            if (textLine.contains("~~~")) {
                textLineWidth = 12 + font.func_78256_a(textLine.replaceAll("~~~(.*?)~~~", ""));
            }
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        if (!containsItemRender) {
            GuiUtils.drawHoveringText((ItemStack)itemStack, textLines, (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)tooltip.maxWidth, (FontRenderer)font);
        } else {
            this.drawHoveringText(itemStack, textLines, mouseX, mouseY, font, tooltipTextWidth, tooltip);
        }
    }

    private void drawHoveringText(@Nonnull ItemStack itemStack, List<String> textLines, int mouseX, int mouseY, FontRenderer font, int tooltipTextWidth, MinecraftTooltip tooltip) {
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        boolean needsWrap = false;
        int maxTextWidth = tooltip.maxWidth;
        int titleLinesCount = 1;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > this.field_146294_l && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > this.field_146294_l / 2 ? mouseX - 12 - 8 : this.field_146294_l - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<String> wrappedTextLines = new ArrayList<String>();
            for (int i = 0; i < textLines.size(); ++i) {
                String textLine = textLines.get(i);
                List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                if (i == 0) {
                    titleLinesCount = wrappedLine.size();
                }
                for (String line : wrappedLine) {
                    int lineWidth = font.func_78256_a(line);
                    if (textLine.contains("~~~")) {
                        lineWidth = 12 + font.func_78256_a(textLine.replaceAll("~~~(.*?)~~~", ""));
                    }
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > this.field_146294_l / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += 2 + (textLines.size() - 1) * 10;
            if (textLines.size() > titleLinesCount) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY + tooltipHeight + 6 > this.field_146295_m) {
            tooltipY = this.field_146295_m - tooltipHeight - 6;
        }
        this.field_73735_i = 300.0f;
        int backgroundColor = -267386864;
        this.func_73733_a(tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, -267386864, -267386864);
        this.func_73733_a(tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, -267386864, -267386864);
        this.func_73733_a(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
        this.func_73733_a(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
        this.func_73733_a(tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, -267386864, -267386864);
        int borderColorStart = 0x50000000 + MinecraftTooltip.getOutline(tooltip.getType());
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        this.func_73733_a(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        this.func_73733_a(tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        this.func_73733_a(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
        this.func_73733_a(tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
        for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
            String line;
            line = textLines.get(lineNumber);
            line = lineNumber == 0 ? MinecraftTooltip.getTitle(tooltip.getType()) + line : MinecraftTooltip.getBody(tooltip.getType()) + line;
            if (line.contains("~~~")) {
                this.drawItem(line, tooltipX, tooltipY);
                line = "   " + line.replaceAll("~~~(.*?)~~~", "");
            }
            font.func_175063_a(line, (float)tooltipX, (float)tooltipY, -1);
            if (lineNumber + 1 == titleLinesCount) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        this.field_73735_i = 0.0f;
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
    }

    private void drawItem(String line, int tooltipX, int tooltipY) {
        String itemTag = line.split("~~~")[1];
        try {
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)itemTag);
            ItemStack stack = new ItemStack(nbt);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)tooltipX, (float)((float)tooltipY - 1.5f), (float)0.0f);
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)1.0f);
            RenderUtil.drawItem(Point.ZERO, stack, false);
            GlStateManager.func_179121_F();
        }
        catch (NBTException e) {
            e.printStackTrace();
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        IWidget origin = this.window;
        if (this.window.getMousedOverWidget() != null) {
            origin = this.window.getMousedOverWidget();
        }
        this.window.callEvent(new EventMouse.Down(origin, x, y, button));
    }

    protected void func_73869_a(char c, int key) {
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() && this.window.getFocusedWidget() == null) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        IWidget origin = this.window.getFocusedWidget() == null ? this.window : this.window.getFocusedWidget();
        this.window.callEvent(new EventKey.Down(origin, c, key));
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.mouseMovedOrUp(mouseX, mouseY, clickedMouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        this.mouseMovedOrUp(mouseX, mouseY, -1);
    }

    protected void mouseMovedOrUp(int x, int y, int button) {
        IWidget origin;
        IWidget iWidget = origin = this.window.getMousedOverWidget() == null ? this.window : this.window.getMousedOverWidget();
        if (button != 0) {
            this.window.callEvent(new EventMouse.Up(origin, x, y, button));
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int dWheel = Mouse.getDWheel();
        if (dWheel != 0) {
            this.window.callEvent(new EventMouse.Wheel(this.window, dWheel));
        }
    }

    public void func_146281_b() {
        this.window.onClose();
        if (this.field_146297_k.field_71439_g != null) {
            this.field_147002_h.func_75134_a((EntityPlayer)this.field_146297_k.field_71439_g);
        }
    }

    public boolean isHelpMode() {
        return Keyboard.isKeyDown((int)15);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void resize(Point size) {
        this.field_146999_f = size.xPos();
        this.field_147000_g = size.yPos();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.window.setPosition(new Point(this.field_147003_i, this.field_147009_r));
    }
}

