/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.wood;

import binnie.core.api.block.TileEntityMetadata;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.blocks.decor.FenceDescription;
import binnie.extratrees.blocks.decor.FenceType;
import binnie.extratrees.modules.ModuleWood;
import binnie.extratrees.wood.EnumETLog;
import binnie.extratrees.wood.EnumShrubLog;
import binnie.extratrees.wood.IFenceProvider;
import binnie.extratrees.wood.IPlankType;
import binnie.extratrees.wood.PlankType;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.IWoodTyped;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WoodManager {
    private static List<IPlankType> PLANK_TYPES;
    private static Map<IPlankType, ItemStack> PLANKS_STACKS;

    public static String getDisplayName(IWoodTyped wood, IWoodType woodType) {
        String displayName;
        WoodBlockKind blockKind = wood.getBlockKind();
        if (woodType instanceof EnumETLog || woodType instanceof EnumShrubLog) {
            String customUnlocalizedName = "tile.et." + blockKind + "." + woodType + ".name";
            if (Translator.canTranslateToLocal((String)customUnlocalizedName)) {
                displayName = Translator.translateToLocal((String)customUnlocalizedName);
            } else {
                String woodGrammar = Translator.translateToLocal((String)("for." + blockKind + ".grammar"));
                String woodTypeName = Translator.translateToLocal((String)("et.trees.woodType." + woodType));
                displayName = woodGrammar.replaceAll("%TYPE", woodTypeName);
            }
        } else {
            throw new IllegalArgumentException("Unknown wood type: " + woodType);
        }
        if (wood.isFireproof()) {
            displayName = Translator.translateToLocalFormatted((String)"tile.for.fireproof", (Object[])new Object[]{displayName});
        }
        return displayName;
    }

    public static IPlankType getPlankType(int index) {
        IDesignMaterial wood = CarpentryManager.carpentryInterface.getWoodMaterial(index);
        if (wood instanceof IPlankType) {
            return (IPlankType)wood;
        }
        return PlankType.ExtraTreePlanks.Fir;
    }

    public static int getPlankTypeIndex(IPlankType type) {
        int index = CarpentryManager.carpentryInterface.getCarpentryWoodIndex(type);
        return index < 0 ? 0 : index;
    }

    @Nullable
    public static FenceType getFenceType(ItemStack stack) {
        FenceDescription desc = WoodManager.getFenceDescription(stack);
        return desc == null ? null : desc.getFenceType();
    }

    @Nullable
    public static FenceDescription getFenceDescription(ItemStack stack) {
        if (stack.func_77973_b() == Item.func_150898_a((Block)ModuleWood.blockMultiFence)) {
            int damage = TileEntityMetadata.getItemDamage(stack);
            return WoodManager.getFenceDescription(damage);
        }
        for (IPlankType type : WoodManager.getAllPlankTypes()) {
            ItemStack f;
            if (!(type instanceof IFenceProvider) || !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(f = ((IFenceProvider)((Object)type)).getFence()))) continue;
            return new FenceDescription(new FenceType(0), type, type);
        }
        return null;
    }

    public static FenceDescription getFenceDescription(int meta) {
        return new FenceDescription(meta);
    }

    public static FenceType getFenceType(int meta) {
        return WoodManager.getFenceDescription(meta).getFenceType();
    }

    public static ItemStack getGate(IPlankType plank) {
        if (plank == PlankType.VanillaPlanks.OAK) {
            return new ItemStack(Blocks.field_180390_bo);
        }
        return TreeManager.woodAccess.getStack(plank.getWoodType(), WoodBlockKind.FENCE_GATE, false);
    }

    public static ItemStack getDoor(IPlankType plank) {
        if (plank == PlankType.VanillaPlanks.OAK) {
            return new ItemStack(Items.field_179570_aq);
        }
        if (plank == PlankType.VanillaPlanks.BIRCH) {
            return new ItemStack(Items.field_179568_as);
        }
        if (plank == PlankType.VanillaPlanks.SPRUCE) {
            return new ItemStack(Items.field_179569_ar);
        }
        if (plank == PlankType.VanillaPlanks.BIG_OAK) {
            return new ItemStack(Items.field_179571_av);
        }
        if (plank == PlankType.VanillaPlanks.JUNGLE) {
            return new ItemStack(Items.field_179567_at);
        }
        if (plank == PlankType.VanillaPlanks.ACACIA) {
            return new ItemStack(Items.field_179572_au);
        }
        return TreeManager.woodAccess.getStack(plank.getWoodType(), WoodBlockKind.DOOR, false);
    }

    public static ItemStack getFence(IPlankType plank, FenceType type, int amount) {
        return WoodManager.getFence(plank, plank, type, amount);
    }

    public static ItemStack getFence(IPlankType plank, IPlankType plank2, FenceType type, int amount) {
        ItemStack original;
        if (plank instanceof IFenceProvider && plank == plank2 && type.isPlain() && !(original = ((IFenceProvider)((Object)plank)).getFence()).func_190926_b()) {
            original.func_190920_e(amount);
            return original;
        }
        int ord = type.ordinal();
        int i = WoodManager.getPlankTypeIndex(plank) + 256 * ord;
        ItemStack stack = TileEntityMetadata.getItemStack((Block)ModuleWood.blockMultiFence, i + 65536 * WoodManager.getPlankTypeIndex(plank2));
        stack.func_190920_e(amount);
        return stack;
    }

    public static List<IPlankType> getAllPlankTypes() {
        if (PLANK_TYPES == null) {
            PLANK_TYPES = new ArrayList<IPlankType>();
            Collections.addAll(PLANK_TYPES, PlankType.ExtraTreePlanks.VALUES);
            Collections.addAll(PLANK_TYPES, PlankType.ForestryPlanks.values());
            Collections.addAll(PLANK_TYPES, PlankType.VanillaPlanks.values());
        }
        return PLANK_TYPES;
    }

    public static Map<IPlankType, ItemStack> getAllPlankStacks() {
        if (PLANKS_STACKS == null) {
            PLANKS_STACKS = new HashMap<IPlankType, ItemStack>();
            for (IPlankType type : WoodManager.getAllPlankTypes()) {
                PLANKS_STACKS.put(type, type.getStack(false));
            }
        }
        return PLANKS_STACKS;
    }

    public static Collection<ItemStack> getAllPlankStacks(IPlankType type) {
        HashMap<IPlankType, ItemStack> planks = new HashMap<IPlankType, ItemStack>(WoodManager.getAllPlankStacks());
        planks.remove(type);
        return planks.values();
    }

    @Nullable
    public static IPlankType getPlankType(ItemStack itemStack) {
        for (IPlankType type : WoodManager.getAllPlankTypes()) {
            if (!type.getStack(false).func_77969_a(itemStack)) continue;
            return type;
        }
        return null;
    }
}

