/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.integration.jei.multifence;

import binnie.extratrees.blocks.decor.FenceDescription;
import binnie.extratrees.blocks.decor.FenceType;
import binnie.extratrees.wood.IPlankType;
import binnie.extratrees.wood.WoodManager;
import java.util.ArrayList;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;

public class MultiFenceRecipeSolidWrapper
implements IShapedCraftingRecipeWrapper {
    private FenceType fenceType;
    @Nullable
    private IPlankType plankType;
    @Nullable
    private IPlankType plankTypeSecondary;

    public MultiFenceRecipeSolidWrapper(FenceType fenceType) {
        this.fenceType = fenceType;
        this.plankType = null;
        this.plankTypeSecondary = null;
    }

    public MultiFenceRecipeSolidWrapper(FenceDescription fenceDesc) {
        this.fenceType = fenceDesc.getFenceType();
        this.plankType = fenceDesc.getPlankType();
        this.plankTypeSecondary = fenceDesc.getSecondaryPlankType();
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<ItemStack> fences = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputFences = new ArrayList<ItemStack>();
        if (this.plankType != null) {
            if (this.plankTypeSecondary == null) {
                for (IPlankType plankTypeSecondary : WoodManager.getAllPlankTypes()) {
                    if (this.plankType == plankTypeSecondary) continue;
                    fences.add(WoodManager.getFence(this.plankType, plankTypeSecondary, new FenceType(this.fenceType.size, false, this.fenceType.embossed), 1));
                    outputFences.add(WoodManager.getFence(this.plankType, plankTypeSecondary, new FenceType(this.fenceType.size, true, this.fenceType.embossed), 2));
                }
            } else {
                fences.add(WoodManager.getFence(this.plankType, this.plankTypeSecondary, new FenceType(this.fenceType.size, false, this.fenceType.embossed), 1));
                outputFences.add(WoodManager.getFence(this.plankType, this.plankTypeSecondary, new FenceType(this.fenceType.size, true, this.fenceType.embossed), 2));
            }
        } else {
            for (IPlankType plankTypeSecondary : WoodManager.getAllPlankTypes()) {
                for (IPlankType plankType : WoodManager.getAllPlankTypes()) {
                    if (plankType == plankTypeSecondary) continue;
                    fences.add(WoodManager.getFence(plankType, plankTypeSecondary, new FenceType(this.fenceType.size, false, this.fenceType.embossed), 1));
                    outputFences.add(WoodManager.getFence(plankType, plankTypeSecondary, new FenceType(this.fenceType.size, true, this.fenceType.embossed), 2));
                }
            }
        }
        ArrayList<ArrayList<ItemStack>> itemInputs = new ArrayList<ArrayList<ItemStack>>();
        itemInputs.add(fences);
        itemInputs.add(fences);
        itemInputs.add(fences);
        ArrayList<ArrayList<ItemStack>> itemOutputs = new ArrayList<ArrayList<ItemStack>>();
        itemOutputs.add(outputFences);
        ingredients.setOutputLists(ItemStack.class, itemOutputs);
        ingredients.setInputLists(ItemStack.class, itemInputs);
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 1;
    }
}

