/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.core.api.block.TileEntityMetadata;
import binnie.core.util.I18N;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.carpentry.BlockDesign;
import binnie.extratrees.carpentry.DesignBlock;
import binnie.extratrees.carpentry.DesignSystem;
import binnie.extratrees.carpentry.GlassType;
import binnie.extratrees.modules.ModuleCarpentry;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStainedDesign
extends BlockDesign {
    public BlockStainedDesign() {
        super(DesignSystem.Glass, Material.field_151592_s);
        this.func_149672_a(SoundType.field_185853_f);
        this.setRegistryName("stainedGlass");
        this.func_149711_c(0.3f);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0 && te instanceof TileEntityMetadata) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            TileEntityMetadata tile = (TileEntityMetadata)te;
            int damage = this.getDroppedMeta(state, tile.getTileMetadata());
            ItemStack itemstack = TileEntityMetadata.getItemStack((Block)this, damage);
            if (!itemstack.func_190926_b()) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack item : items) {
                BlockStainedDesign.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        return block != this;
    }

    @Override
    public ItemStack getCreativeStack(IDesign design) {
        return ModuleCarpentry.getItemStack((BlockDesign)this, GlassType.get(0), GlassType.get(1), design);
    }

    @Override
    public String getBlockName(DesignBlock design) {
        return I18N.localise("extratrees.block.stainedglass.name", design.getDesign().getName());
    }
}

