/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.controls.tab;

import binnie.core.gui.IWidget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.core.IControlValue;
import binnie.core.gui.controls.tab.ControlTab;
import binnie.core.gui.events.EventHandler;
import binnie.core.gui.events.EventValueChanged;
import binnie.core.gui.geometry.Position;
import com.google.common.collect.Iterables;
import java.util.Collection;

public class ControlTabBar<T>
extends Control
implements IControlValue<T> {
    private T value;
    private Position position;

    public ControlTabBar(IWidget parent, int x, int y, int width, int height, Position position, Collection<T> values) {
        this(parent, x, y, width, height, position, Iterables.get(values, (int)0));
        super.setValues(values);
    }

    public ControlTabBar(IWidget parent, int x, int y, int width, int height, Position position, T value) {
        super(parent, x, y, width, height);
        this.value = value;
        this.position = position;
        this.addEventHandler(EventValueChanged.class, EventHandler.Origin.DIRECT_CHILD, this, event -> this.setValue(event.getValue()));
    }

    private void setValues(Collection<T> values) {
        this.deleteAllChildren();
        float length = values.size();
        int tabDimension = (int)((float)this.getSize().yPos() / length);
        if (this.position == Position.Top || this.position == Position.BOTTOM) {
            tabDimension = (int)((float)this.getSize().xPos() / length);
        }
        int j = 0;
        for (T value : values) {
            if (this.position == Position.Top || this.position == Position.BOTTOM) {
                this.createTab(j * tabDimension, 0, tabDimension, this.getSize().yPos(), value);
            } else {
                this.createTab(0, j * tabDimension, this.getSize().xPos(), tabDimension, value);
            }
            ++j;
        }
    }

    public ControlTab<T> createTab(int x, int y, int w, int h, T value) {
        return new ControlTab<T>(this, x, y, w, h, value);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        boolean change = this.value != value;
        this.value = value;
        if (change) {
            this.callEvent(new EventValueChanged<T>(this, value));
        }
    }

    public Position getDirection() {
        return this.position;
    }
}

