/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui;

import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITopLevelWidget;
import binnie.core.gui.IWidget;
import binnie.core.gui.IWidgetAttribute;
import binnie.core.gui.RenderStage;
import binnie.core.gui.events.Event;
import binnie.core.gui.events.EventHandler;
import binnie.core.gui.events.EventWidget;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Widget
implements IWidget {
    @Nullable
    private final IWidget parent;
    @Nullable
    Area cropArea;
    @Nullable
    IWidget cropWidget;
    boolean cropped = false;
    int colour = 0xFFFFFF;
    private List<IWidget> children = new ArrayList<IWidget>();
    private List<IWidgetAttribute> attributes = new ArrayList<IWidgetAttribute>();
    private Point position = Point.ZERO;
    private Point size = Point.ZERO;
    private Point offset = Point.ZERO;
    private Collection<EventHandler<? extends Event>> eventHandlers = new ArrayList<EventHandler<? extends Event>>();
    private boolean visible = true;

    public Widget(@Nullable IWidget parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    @Override
    public boolean hasAttribute(IWidgetAttribute attribute) {
        return this.attributes.contains(attribute);
    }

    public boolean addAttribute(IWidgetAttribute attribute) {
        return this.attributes.add(attribute);
    }

    @Override
    public void deleteChild(IWidget child) {
        if (child == null) {
            return;
        }
        child.delete();
        this.children.remove(child);
    }

    public final void deleteAllChildren() {
        while (!this.children.isEmpty()) {
            this.deleteChild(this.children.get(0));
        }
    }

    @Override
    public void addChild(IWidget child) {
        if (child == null) {
            return;
        }
        IWidget topWidget = this.getTopChild();
        if (topWidget != null && topWidget.hasAttribute(Attribute.ALWAYS_ON_TOP)) {
            this.children.add(this.children.size() - 1, child);
        } else {
            this.children.add(child);
        }
    }

    @Nullable
    protected IWidget getFirstChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.get(0);
    }

    @Override
    public final List<IWidget> getChildren() {
        return this.children;
    }

    @Override
    @Nullable
    public <W> W getWidget(Class<W> widgetClass) {
        for (IWidget child : this.getChildren()) {
            if (widgetClass.isInstance(child)) {
                return widgetClass.cast(child);
            }
            W found = child.getWidget(widgetClass);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public IWidget getTopChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        int childrenCount = this.getChildren().size();
        return this.children.get(childrenCount - 1);
    }

    @Override
    @Nullable
    public IWidget getParent() {
        return this.parent;
    }

    @Override
    public final ITopLevelWidget getTopParent() {
        if (this.parent == null) {
            return (ITopLevelWidget)((Object)this);
        }
        return this.parent.getTopParent();
    }

    @Override
    public final void setPosition(Point position) {
        if (!position.equals(this.position)) {
            this.position = new Point(position);
            this.callEvent(new EventWidget.ChangePosition(this));
        }
    }

    @Override
    public final Point getPosition() {
        return this.position.add(this.offset);
    }

    @Override
    public final Point getSize() {
        return this.size;
    }

    @Override
    public final Area getArea() {
        return new Area(Point.ZERO, this.getSize());
    }

    @Override
    @Nullable
    public final Area getCroppedZone() {
        return this.cropArea;
    }

    @Override
    public final void setCroppedZone(IWidget relative, Area area) {
        this.cropArea = area;
        this.cropped = true;
        this.cropWidget = relative;
    }

    @Override
    public final Point getAbsolutePosition() {
        IWidget parent = this.getParent();
        return parent == null ? this.getPosition() : parent.getAbsolutePosition().add(this.getPosition());
    }

    public final void setSize(Point vector) {
        if (!vector.equals(this.size)) {
            this.size = new Point(vector);
            this.callEvent(new EventWidget.ChangeSize(this));
        }
    }

    @Override
    public final void setOffset(Point vector) {
        if (vector != this.offset) {
            this.offset = new Point(vector);
            this.callEvent(new EventWidget.ChangeOffset(this));
        }
    }

    public final int getXPos() {
        return this.getPosition().xPos();
    }

    @Override
    public final int getYPos() {
        return this.getPosition().yPos();
    }

    @Override
    public final int getWidth() {
        return this.getSize().xPos();
    }

    @Override
    public final int getHeight() {
        return this.getSize().yPos();
    }

    @Override
    public final int getColor() {
        return this.colour;
    }

    @Override
    public final void setColor(int colour) {
        if (this.colour != colour) {
            this.colour = colour;
            this.callEvent(new EventWidget.ChangeColour(this));
        }
    }

    @Override
    public boolean canFocus() {
        return this.hasAttribute(Attribute.CAN_FOCUS);
    }

    @Override
    public <E extends Event> void addEventHandler(Class<? super E> eventClass, EventHandler.OnEventHandler<E> handler) {
        this.eventHandlers.add(new EventHandler<E>(eventClass, handler));
    }

    @Override
    public <E extends Event> void addEventHandler(Class<? super E> eventClass, EventHandler.Origin origin, IWidget relative, EventHandler.OnEventHandler<E> handler) {
        this.eventHandlers.add(new EventHandler<E>(eventClass, origin, relative, handler));
    }

    @Override
    public <E extends Event> void addSelfEventHandler(Class<? super E> eventClass, EventHandler.OnEventHandler<E> handler) {
        this.eventHandlers.add(new EventHandler<E>(eventClass, EventHandler.Origin.SELF, this, handler));
    }

    public void callEvent(Event event) {
        this.getTopParent().receiveEvent(event);
    }

    @Override
    public void receiveEvent(Event event) {
        for (EventHandler<? extends Event> handler : this.eventHandlers) {
            if (!handler.handles(event)) continue;
            handler.onEvent(event);
        }
        LinkedList<IWidget> children = new LinkedList<IWidget>(this.getChildren());
        for (IWidget child : children) {
            child.receiveEvent(event);
        }
    }

    @Override
    public boolean canMouseOver() {
        return this.hasAttribute(Attribute.MOUSE_OVER);
    }

    public Point getMousePosition() {
        return this.getTopParent().getAbsoluteMousePosition();
    }

    @Override
    public final Point getRelativeMousePosition() {
        IWidget parent = this.getParent();
        return parent == null ? this.getMousePosition() : parent.getRelativeMousePosition().sub(this.getPosition());
    }

    @Override
    public final boolean calculateIsMouseOver() {
        Point mouse = this.getRelativeMousePosition();
        if (!this.cropped || this.cropArea == null) {
            return this.isMouseOverWidget(mouse);
        }
        IWidget cropRelative = this.cropWidget != null ? this.cropWidget : this;
        Point pos = Point.sub(cropRelative.getAbsolutePosition(), this.getAbsolutePosition());
        Point size = new Point(this.cropArea.size().xPos(), this.cropArea.size().yPos());
        boolean inCrop = mouse.xPos() > pos.xPos() && mouse.yPos() > pos.yPos() && mouse.xPos() < pos.xPos() + size.xPos() && mouse.yPos() < pos.yPos() + size.yPos();
        return inCrop && this.isMouseOverWidget(mouse);
    }

    public boolean isMouseOverWidget(Point relativeMouse) {
        return this.getArea().contains(relativeMouse);
    }

    public final boolean isMouseOver() {
        return this.getTopParent().isMouseOver(this);
    }

    @Override
    public boolean isCroppedWidet() {
        return this.cropped;
    }

    @Override
    public final IWidget getCropWidget() {
        return this.cropWidget == null ? this : this.cropWidget;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void render(int guiWidth, int guiHeight) {
        if (!this.isVisible()) {
            return;
        }
        CraftGUI.RENDER.preRender(this, guiWidth, guiHeight);
        this.onRender(RenderStage.PRE_CHILDREN, guiWidth, guiHeight);
        for (IWidget widget : this.getChildren()) {
            widget.render(guiWidth, guiHeight);
        }
        for (IWidget widget : this.getChildren()) {
            CraftGUI.RENDER.preRender(widget, guiWidth, guiHeight);
            widget.onRender(RenderStage.POST_SIBLINGS, guiWidth, guiHeight);
            CraftGUI.RENDER.postRender(widget);
        }
        this.onRender(RenderStage.POST_CHILDREN, guiWidth, guiHeight);
        CraftGUI.RENDER.postRender(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRender(RenderStage stage, int guiWidth, int guiHeight) {
        if (stage == RenderStage.PRE_CHILDREN) {
            this.onRenderBackground(guiWidth, guiHeight);
        }
        if (stage == RenderStage.POST_CHILDREN) {
            this.onRenderForeground(guiWidth, guiHeight);
        }
        if (stage == RenderStage.POST_SIBLINGS) {
            this.onRenderOverlay();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onRenderForeground(int guiWidth, int guiHeight) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onRenderOverlay() {
    }

    @Override
    public boolean isEnabled() {
        IWidget parent = this.getParent();
        return parent == null || parent.isEnabled();
    }

    @Override
    public final void show() {
        this.visible = true;
        this.callEvent(new EventWidget.Show(this));
    }

    @Override
    public final void hide() {
        this.visible = false;
        this.callEvent(new EventWidget.Hide(this));
    }

    @Override
    public final boolean isVisible() {
        if (this.visible) {
            IWidget parent = this.getParent();
            return parent == null || parent.isVisible() && parent.isChildVisible(this);
        }
        return false;
    }

    @Override
    public boolean isChildVisible(IWidget child) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void updateClient() {
        if (!this.isVisible()) {
            return;
        }
        if (this.getTopParent() == this) {
            ((ITopLevelWidget)((Object)this)).updateTopLevel();
        }
        this.onUpdateClient();
        for (IWidget widget : this.getChildren()) {
            widget.updateClient();
        }
    }

    @Override
    public final void delete() {
        this.getTopParent().widgetDeleted(this);
    }

    public IWidget getWidget() {
        return this;
    }
}

