/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.FluidType;
import binnie.core.liquid.IFluidDefinition;
import binnie.extratrees.alcohol.CocktailLiquid;
import binnie.extratrees.alcohol.ICocktailIngredient;
import binnie.extratrees.alcohol.ICocktailIngredientProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public enum Spirit implements IFluidDefinition,
ICocktailIngredientProvider
{
    NeutralSpirit("Neutral Spirit", "spirit.neutral", 0xFFFFFF, 0.05, 0.8f),
    Vodka("Vodka", "vodka", 16053751, 0.05, 0.4f),
    WhiteRum("White Rum", "rum.white", 15132132, 0.05, 0.4f),
    DarkRum("Dark Rum", "rum.dark", 11018752, 0.4, 0.4f),
    Whiskey("Whiskey", "whiskey", 13594368, 0.2, 0.4f),
    CornWhiskey("Bourbon", "whiskey.corn", 9835009, 0.2, 0.4f),
    RyeWhiskey("Rye Whiskey", "whiskey.rye", 16085800, 0.2, 0.4f),
    WheatWhiskey("Wheat Whiskey", "whiskey.wheat", 14976530, 0.2, 0.4f),
    FortifiedWine("Fortified Wine", "wine.fortified", 15569439, 0.2, 0.2f),
    Tequila("Tequila", "tequila", 16116160, 0.05, 0.4f),
    Brandy("Brandy", "brandy.grape", 16228128, 0.2, 0.4f),
    AppleBrandy("Apple Brandy", "brandy.apple", 14985790, 0.2, 0.4f),
    PearBrandy("Pear Brandy", "brandy.pear", 16696883, 0.2, 0.4f),
    ApricotBrandy("Apricot Brandy", "brandy.apricot", 13336387, 0.2, 0.4f),
    PlumBrandy("Plum Brandy", "brandy.plum", 9511697, 0.2, 0.4f),
    CherryBrandy("Cherry Brandy", "brandy.cherry", 8588062, 0.2, 0.4f),
    ElderberryBrandy("Elderberry Brandy", "brandy.elderberry", 12462919, 0.2, 0.4f),
    CitrusBrandy("Citrus Brandy", "brandy.citrus", 13336387, 0.2, 0.4f),
    FruitBrandy("Fruit Brandy", "brandy.fruit", 14985790, 0.2, 0.4f),
    Cachaca("Cachaca", "spirit.sugarcane", 15331535, 0.1, 0.4f),
    Gin("Gin", "spirit.gin", 0xF6F6F6, 0.05, 0.4f),
    AppleLiquor("Apple Liquor", "liquor.apple", 0xCCCCCC, 0.05, 0.4f),
    PearLiquor("Pear Liquor", "liquor.pear", 0xCCCCCC, 0.05, 0.4f),
    CherryLiquor("Cherry Liquor", "liquor.cherry", 0xCCCCCC, 0.05, 0.4f),
    ElderberryLiquor("Elderberry Liquor", "liquor.elderberry", 0xCCCCCC, 0.05, 0.4f),
    ApricotLiquor("Apricot Liquor", "liquor.apricot", 0xCCCCCC, 0.05, 0.4f),
    FruitLiquor("Fruit Liquor", "liquor.fruit", 0xCCCCCC, 0.05, 0.4f);

    float abv;
    FluidType type;
    CocktailLiquid cocktailLiquid;

    private Spirit(String name, String ident, int color, double transparency, float abv) {
        this.abv = abv;
        this.type = new FluidType(ident, name, color).setTextures(new ResourceLocation("extratrees", "blocks/liquids/liquid")).setShowHandler(type -> type == FluidContainerType.GLASS).setTransparency(transparency);
        this.cocktailLiquid = new CocktailLiquid(this.type, abv);
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public FluidStack get(int amount) {
        return this.type.get(amount);
    }

    @Override
    public FluidType getType() {
        return this.type;
    }

    @Override
    public ICocktailIngredient getIngredient() {
        return this.cocktailLiquid;
    }
}

