/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.database;

import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITooltip;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.database.WindowAbstractDatabase;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.resource.Texture;
import binnie.core.gui.resource.minecraft.CraftGUITextureSheet;
import binnie.core.gui.resource.minecraft.StandardTexture;
import binnie.core.util.I18N;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

class ControlMutationSymbol
extends Control
implements ITooltip {
    private static Texture MutationPlus = new StandardTexture(2, 94, 16, 16, CraftGUITextureSheet.CONTROLS_2);
    private static Texture MutationArrow = new StandardTexture(20, 94, 32, 16, CraftGUITextureSheet.CONTROLS_2);
    private IMutation value = null;
    private boolean discovered;
    private int type;

    protected ControlMutationSymbol(IWidget parent, int x, int y, int type) {
        super(parent, x, y, 16 + type * 16, 16);
        this.type = type;
        this.addAttribute(Attribute.MOUSE_OVER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        super.onRenderBackground(guiWidth, guiHeight);
        if (this.type == 0) {
            CraftGUI.RENDER.texture(MutationPlus, Point.ZERO);
        } else {
            CraftGUI.RENDER.texture(MutationArrow, Point.ZERO);
        }
    }

    public void setValue(IMutation value) {
        this.value = value;
        boolean isNEI = ((WindowAbstractDatabase)this.getTopParent()).isNEI();
        IBreedingSystem system = ((WindowAbstractDatabase)this.getTopParent()).getBreedingSystem();
        boolean bl = this.discovered = isNEI || system.isMutationDiscovered(value, ((Window)Window.get(this)).getWorld(), ((Window)Window.get(this)).getUsername());
        if (this.discovered) {
            this.setColor(0xFFFFFF);
        } else {
            this.setColor(0x777777);
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        if (this.type == 1 && this.discovered) {
            IAlleleSpecies species1 = this.value.getAllele0();
            IAlleleSpecies species2 = this.value.getAllele1();
            IBreedingSystem system = ((WindowAbstractDatabase)this.getTopParent()).getBreedingSystem();
            float chance = system.getChance(this.value, ((Window)Window.get(this)).getPlayer(), species1, species2);
            tooltip.add(I18N.localise("binniecore.gui.database.control.chance", Float.valueOf(chance)));
            for (String string : this.value.getSpecialConditions()) {
                tooltip.add(string);
            }
        }
    }
}

