/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.FluidDefinition;
import binnie.core.liquid.IFluidType;
import binnie.extratrees.alcohol.ICocktailLiquid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public enum MiscFluid implements IFluidType,
ICocktailLiquid
{
    CarbonatedWater("Carbonated Water", "water.carbonated", 0xCCCCFF, (double)0.1f),
    TonicWater("Tonic Water", "water.tonic", 0xCCCCFF, (double)0.1f),
    Cream("Carbonated Water", "cream", 0xEAEADE, 2.0),
    GingerAle("Ginger Ale", "gingerAle", 0xFFFFFF, (double)0.6f),
    Coffee("Coffee", "coffee", 5910789, (double)0.3f),
    SugarSyrup("Simple Syrup", "syrup.simple", 16120049, (double)0.1f),
    AgaveNectar("Agave Nectar", "syrup.agave", 13598245, (double)0.7f),
    GrenadineSyrup("Grenadine Syrup", "syrup.grenadine", 16009573, (double)0.8f);

    FluidDefinition definition;

    private MiscFluid(String name, String ident, int color, double transparency) {
        this.definition = new FluidDefinition(ident, name, color).setTransparency(transparency).setTextures(new ResourceLocation("extratrees", "blocks/liquids/liquid")).setShowHandler(type -> type == FluidContainerType.GLASS);
    }

    public String toString() {
        return this.definition.toString();
    }

    @Override
    public String getDisplayName() {
        return this.definition.getDisplayName();
    }

    @Override
    public String getIdentifier() {
        return this.definition.getIdentifier();
    }

    @Override
    public int getColor() {
        return this.definition.getColor();
    }

    @Override
    public FluidStack get(int amount) {
        return this.definition.get(amount);
    }

    @Override
    public int getTransparency() {
        return this.definition.getTransparency();
    }

    @Override
    public String getTooltip(int ratio) {
        return ratio + " Part" + (ratio > 1 ? "s " : " ") + this.getDisplayName();
    }

    @Override
    public float getABV() {
        return 0.0f;
    }

    @Override
    public FluidDefinition getDefinition() {
        return this.definition;
    }
}

