/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.FluidDefinition;
import binnie.core.liquid.IFluidType;
import binnie.extratrees.alcohol.ICocktailLiquid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public enum Liqueur implements IFluidType,
ICocktailLiquid
{
    Almond("Almond", 14966063, 0.3, 0.2),
    Orange("Orange", 16353536, 0.4, 0.2),
    Banana("Banana", 16302592, 0.5, 0.2),
    Chocolate("Chocolate", 12667680, 0.3, 0.2),
    Mint("Mint", 2737788, 0.4, 0.2),
    Hazelnut("Hazelnut", 15570987, 0.3, 0.2),
    Cinnamon("Cinnamon", 0xE55000, 0.3, 0.2),
    Coffee("Coffee", 9847577, 0.4, 0.2),
    Melon("Melon", 11584049, 0.4, 0.2),
    Anise("Anise", 14344681, 0.3, 0.2),
    Peach("Peach", 16684384, 0.4, 0.2),
    Lemon("Lemon", 16311405, 0.4, 0.2),
    Herbal("Herbal", 16700673, 0.3, 0.2),
    Cherry("Cherry", 14096641, 0.5, 0.2),
    Blackcurrant("Blackcurrant", 6962541, 0.5, 0.2),
    Blackberry("Blackberry", 6837581, 0.5, 0.2),
    Raspberry("Raspberry", 10158848, 0.5, 0.2);

    float abv;
    final FluidDefinition definition;

    private Liqueur(String name, int colour, double transparency, double abv) {
        this(name + " Liqueur", "liqueur." + name.toLowerCase(), colour, transparency, abv);
    }

    private Liqueur(String name, String ident, int color, double transparency, double abv) {
        this.abv = (float)abv;
        this.definition = new FluidDefinition(ident, name, color).setTransparency(transparency).setTextures(new ResourceLocation("extratrees", "blocks/liquids/liquid")).setShowHandler(type -> type == FluidContainerType.GLASS);
    }

    private void addFlavour(String oreDict) {
    }

    public String toString() {
        return this.definition.toString();
    }

    @Override
    public String getDisplayName() {
        return this.definition.getDisplayName();
    }

    @Override
    public FluidStack get(int amount) {
        return this.definition.get(amount);
    }

    @Override
    public int getColor() {
        return this.definition.getColor();
    }

    @Override
    public int getTransparency() {
        return this.definition.getTransparency();
    }

    @Override
    public String getTooltip(int ratio) {
        return ratio + " Part" + (ratio > 1 ? "s " : " ") + this.definition.getDisplayName();
    }

    @Override
    public float getABV() {
        return this.abv;
    }

    @Override
    public String getIdentifier() {
        return this.definition.getIdentifier();
    }

    @Override
    public FluidDefinition getDefinition() {
        return this.definition;
    }

    static {
        Almond.addFlavour("cropAlmond");
        Orange.addFlavour("cropOrange");
        Banana.addFlavour("cropBanana");
        Chocolate.addFlavour("cropCocoa");
        Mint.addFlavour("cropMint");
        Hazelnut.addFlavour("cropHazelnut");
        Cinnamon.addFlavour("cropCinnamon");
        Coffee.addFlavour("cropCoffee");
        Melon.addFlavour("cropMelon");
        Anise.addFlavour("cropAnise");
        Peach.addFlavour("cropPeach");
        Lemon.addFlavour("cropLemon");
        Herbal.addFlavour("cropHerbal");
        Cherry.addFlavour("cropCherry");
        Blackcurrant.addFlavour("cropBlackcurrant");
        Blackberry.addFlavour("cropBlackberry");
        Raspberry.addFlavour("cropRaspberry");
    }
}

