/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.FluidDefinition;
import binnie.core.liquid.IFluidType;
import binnie.core.util.I18N;
import binnie.extratrees.alcohol.ICocktailLiquid;
import binnie.extratrees.alcohol.Juice;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public enum Alcohol implements IFluidType,
ICocktailLiquid
{
    Apple("cider.apple", 16432700, 0.3, 0.05){

        @Override
        protected void init() {
            this.addFementation(Juice.Apple);
        }
    }
    ,
    Apricot("wine.apricot", 15781686, 0.3, 0.1){

        @Override
        protected void init() {
            this.addFementation(Juice.Apricot);
        }
    }
    ,
    Banana("wine.banana", 14993485, 0.3, 0.1){

        @Override
        protected void init() {
            this.addFementation(Juice.Banana);
        }
    }
    ,
    Cherry("wine.cherry", 11207702, 0.3, 0.1){

        @Override
        protected void init() {
            this.addFementation(Juice.Cherry);
        }
    }
    ,
    Elderberry("wine.elderberry", 9764865, 0.3, 0.1){

        @Override
        protected void init() {
            this.addFementation(Juice.Elderberry);
        }
    }
    ,
    Peach("cider.peach", 15361563, 0.3, 0.05){

        @Override
        protected void init() {
            this.addFementation(Juice.Peach);
        }
    }
    ,
    Pear("ciderpear", 15061095, 0.3, 0.05){

        @Override
        protected void init() {
            this.addFementation(Juice.Pear);
        }
    }
    ,
    Plum("wine.plum", 12063752, 0.3, 0.1){

        @Override
        protected void init() {
            this.addFementation(Juice.Plum);
        }
    }
    ,
    Carrot("wine.carrot", 16219394, 0.3, 0.1){

        @Override
        protected void init() {
            this.addFementation(Juice.Carrot);
        }
    }
    ,
    WhiteWine("wine.white", 15587989, 0.1, 0.1){

        @Override
        protected void init() {
            this.addFementation(Juice.WhiteGrape);
        }
    }
    ,
    RedWine("wine.red", 7670539, 0.2, 0.1){

        @Override
        protected void init() {
            this.addFementation(Juice.RedGrape);
        }
    }
    ,
    SparklingWine("wine.sparkling", 16709566, 0.1, 0.1),
    Agave("wine.agave", 13938276, 0.2, 0.1),
    Potato("fermented.potatoes", 12028240, 0.8, 0.1){

        @Override
        protected void init() {
            this.addFementation("cropPotato");
        }
    }
    ,
    Citrus("wine.citrus", 0xFFFF00, 0.2, 0.1){

        @Override
        protected void init() {
            this.addFementation(Juice.Lemon);
            this.addFementation(Juice.Lime);
            this.addFementation(Juice.Orange);
            this.addFementation(Juice.Grapefruit);
        }
    }
    ,
    Cranberry("wine.cranberry", 11599874, 0.2, 0.1){

        @Override
        protected void init() {
            this.addFementation(Juice.Cranberry);
        }
    }
    ,
    Pineapple("wine.pineapple", 14724150, 0.2, 0.1){

        @Override
        protected void init() {
            this.addFementation(Juice.Pineapple);
        }
    }
    ,
    Tomato("wine.tomato", 12458521, 0.2, 0.1){

        @Override
        protected void init() {
            this.addFementation(Juice.Tomato);
        }
    }
    ,
    Fruit("juice", 16432700, 0.2, 0.1),
    Ale("beer.ale", 12991009, 0.7, 0.05),
    Lager("beer.lager", 15301637, 0.7, 0.05),
    WheatBeer("beer.wheat", 14380552, 0.7, 0.05),
    RyeBeer("beer.rye", 10836007, 0.7, 0.05),
    CornBeer("beer.corn", 13411364, 0.7, 0.05),
    Stout("beer.stout", 5843201, 0.8, 0.05),
    Barley("mash.grain", 12991009, 0.9, 0.05),
    Wheat("mash.wheat", 12991009, 0.9, 0.05),
    Rye("mash.rye", 10836007, 0.9, 0.05),
    Corn("mash.corn", 13411364, 0.9, 0.05);

    final List<String> fermentationLiquid = new ArrayList<String>();
    final float abv;
    final FluidDefinition definition;
    String fermentationSolid = "";

    private Alcohol(String ident, int color, double transparency, double abv) {
        this.abv = (float)abv;
        this.init();
        this.definition = new FluidDefinition(ident, "extratrees.fluid.alcohol." + this.name().toLowerCase(), color).setTransparency(transparency).setTextures(new ResourceLocation("extratrees", "blocks/liquids/liquid")).setPlaceHandler(type -> type == FluidContainerType.GLASS);
    }

    protected void init() {
    }

    @Override
    public FluidDefinition getDefinition() {
        return this.definition;
    }

    public List<String> getFermentationLiquid() {
        return this.fermentationLiquid;
    }

    protected void addFementation(Juice juice) {
        this.fermentationLiquid.add(juice.getIdentifier());
    }

    protected void addFementation(String oreDict) {
        this.fermentationSolid = oreDict;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return I18N.localise("extratrees.fluid.alcohol." + this.name().toLowerCase());
    }

    @Override
    public String getIdentifier() {
        return this.definition.getIdentifier();
    }

    @Override
    public FluidStack get(int amount) {
        return this.definition.get(amount);
    }

    @Override
    public int getColor() {
        return this.definition.getColor();
    }

    @Override
    public int getTransparency() {
        return this.definition.getTransparency();
    }

    @Override
    public String getTooltip(int ratio) {
        return ratio + " Part" + (ratio > 1 ? "s " : " ") + this.definition.getDisplayName();
    }

    @Override
    public float getABV() {
        return this.abv;
    }
}

