/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.inventory.SidedAccess;
import binnie.core.machines.inventory.Validator;
import binnie.core.util.IValidator;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import java.util.Collection;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;

public abstract class BaseSlot<T>
implements INbtWritable,
INbtReadable,
IValidator<T> {
    protected String unlocName = "";
    @Nullable
    Validator<T> validator = null;
    private SidedAccess access = new SidedAccess();
    private boolean readOnly = false;
    private int index;

    public BaseSlot(int index, String unlocName) {
        this.setIndex(index);
        this.setUnlocalisedName(unlocName);
    }

    public void setReadOnly() {
        this.readOnly = true;
        this.forbidInsertion();
    }

    @Override
    public boolean isValid(T item) {
        return item == null || this.validator == null || this.validator.isValid(item);
    }

    @Nullable
    public abstract T getContent();

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getIndex() {
        return this.index;
    }

    private void setIndex(int index) {
        this.index = index;
    }

    public boolean canInsert() {
        return !this.access.getInsertionSides().isEmpty();
    }

    public boolean canExtract() {
        return !this.access.getExtractionSides().isEmpty();
    }

    public void forbidInteraction() {
        this.forbidInsertion();
        this.forbidExtraction();
    }

    public void forbidExtraction() {
        this.access.setExtract(false);
        this.access.forbidExtractChange();
    }

    public void forbidInsertion() {
        this.access.setInsert(false);
        this.access.forbidInsertChange();
    }

    public boolean canInsert(EnumFacing dir) {
        return this.access.canInsert(dir);
    }

    public boolean canExtract(EnumFacing dir) {
        return this.access.canExtract(dir);
    }

    public Collection<EnumFacing> getInputSides() {
        return this.access.getInsertionSides();
    }

    public Collection<EnumFacing> getOutputSides() {
        return this.access.getExtractionSides();
    }

    public void setOutputSides(EnumSet<EnumFacing> sides) {
        for (EnumFacing side : EnumSet.complementOf(sides)) {
            this.access.setExtract(side, false);
        }
    }

    public void setUnlocalisedName(String name) {
        this.unlocName = name;
    }

    public abstract String getName();

    @Nullable
    public Validator<T> getValidator() {
        return this.validator;
    }

    public BaseSlot<T> setValidator(Validator<T> val) {
        this.validator = val;
        return this;
    }
}

