/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.ManagerBase;
import binnie.core.liquid.BinnieFluid;
import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.FluidDefinition;
import binnie.core.liquid.IFluidType;
import binnie.core.util.RecipeUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ManagerLiquid
extends ManagerBase {
    public static final String WATER = "water";
    public static final String CREOSOTE = "fluid.creosote";
    Map<String, FluidDefinition> definitions = new LinkedHashMap<String, FluidDefinition>();

    public void createLiquids(IFluidType[] liquids) {
        for (IFluidType liquid : liquids) {
            FluidDefinition definition = liquid.getDefinition();
            BinnieFluid fluid = this.createLiquid(definition);
            if (fluid != null) continue;
            throw new RuntimeException("Liquid registered incorrectly - " + definition.getIdentifier());
        }
    }

    public BinnieFluid createLiquid(FluidDefinition fluid) {
        this.definitions.put(fluid.getIdentifier().toLowerCase(), fluid);
        BinnieFluid bFluid = new BinnieFluid(fluid);
        FluidRegistry.registerFluid((Fluid)bFluid);
        FluidRegistry.addBucketForFluid((Fluid)bFluid);
        return bFluid;
    }

    @Nullable
    public FluidStack getFluidStack(String name, int amount) {
        return FluidRegistry.getFluidStack((String)name.toLowerCase(), (int)amount);
    }

    @Nullable
    public FluidStack getFluidStack(String name) {
        return this.getFluidStack(name, 1000);
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        RecipeUtil recipeUtil = new RecipeUtil("binniecore");
        recipeUtil.addShapelessRecipe("glass_container_conversion", FluidContainerType.GLASS.get(1), Items.field_151069_bo);
        recipeUtil.addShapelessRecipe("glass_bottle_conversion", new ItemStack(Items.field_151069_bo), FluidContainerType.GLASS.get(1));
        recipeUtil.addRecipe("glass_container", FluidContainerType.GLASS.get(3), " b ", "g g", " g ", Character.valueOf('g'), "blockGlass", Character.valueOf('b'), "slabWood");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(TextureStitchEvent event) {
        TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
        for (FluidDefinition definition : this.definitions.values()) {
            textureMap.func_174942_a(definition.getFlowing());
            textureMap.func_174942_a(definition.getStill());
        }
    }
}

