/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.Binnie;
import binnie.core.liquid.FluidContainerType;
import binnie.core.util.I18N;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidDefinition {
    public ResourceLocation textureFlowing;
    public ResourceLocation textureStill;
    public int color;
    public int containerColor;
    public int transparency;
    public String unlocalizedName;
    public String identifier;
    public ContainerShowHandler showHandler = t -> true;
    public ContainerPlaceHandler placeHandler = t -> true;

    public FluidDefinition(String identifier, String unlocalizedName, int color) {
        this.identifier = "binnie." + identifier;
        this.unlocalizedName = unlocalizedName;
        this.color = color;
        this.containerColor = color;
        this.setTextures(new ResourceLocation("binniecore", "blocks/liquids/blank"));
    }

    public FluidDefinition setTextures(ResourceLocation texture) {
        this.textureFlowing = texture;
        this.textureStill = texture;
        return this;
    }

    public FluidDefinition setTextureFlowing(ResourceLocation textureFlowing) {
        this.textureFlowing = textureFlowing;
        return this;
    }

    public ResourceLocation getFlowing() {
        return this.textureFlowing;
    }

    public FluidDefinition setTextureStill(ResourceLocation textureStill) {
        this.textureStill = textureStill;
        return this;
    }

    public ResourceLocation getStill() {
        return this.textureStill;
    }

    public String getDisplayName() {
        return I18N.localise(this.unlocalizedName);
    }

    public FluidDefinition setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public FluidDefinition setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public FluidStack get(int amount) {
        return Binnie.LIQUID.getFluidStack(this.getIdentifier(), amount);
    }

    public FluidStack get() {
        return this.get(1000);
    }

    public FluidDefinition setColor(int color) {
        this.color = color;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public FluidDefinition setContainerColor(int containerColor) {
        this.containerColor = containerColor;
        return this;
    }

    public int getContainerColor() {
        return this.containerColor;
    }

    public FluidDefinition setTransparency(double transparency) {
        this.transparency = (int)(Math.min(1.0, transparency + 0.3) * 255.0);
        return this;
    }

    public FluidDefinition setTransparency(int transparency) {
        this.transparency = transparency;
        return this;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public FluidDefinition setPlaceHandler(ContainerPlaceHandler placeHandler) {
        this.placeHandler = placeHandler;
        return this;
    }

    public FluidDefinition setShowHandler(ContainerShowHandler showHandler) {
        this.showHandler = showHandler;
        return this;
    }

    public boolean canPlaceIn(FluidContainerType type) {
        return this.placeHandler.canPlaceIn(type);
    }

    public boolean showInCreative(FluidContainerType type) {
        return this.showHandler.showInCreative(type);
    }

    public FluidDefinition getDefinition() {
        return this;
    }

    public static interface ContainerPlaceHandler {
        public boolean canPlaceIn(FluidContainerType var1);
    }

    public static interface ContainerShowHandler {
        public boolean showInCreative(FluidContainerType var1);
    }
}

