/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import binnie.core.Binnie;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.genetics.Gene;
import binnie.genetics.api.IGene;
import binnie.genetics.genetics.IGeneItem;
import forestry.api.core.INbtWritable;
import forestry.api.genetics.ISpeciesRoot;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GeneItem
implements INbtWritable,
IGeneItem {
    private IGene gene;

    public GeneItem(IGene gene) {
        this.gene = gene;
    }

    @Nullable
    public static GeneItem create(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("gene", 10)) {
            NBTTagCompound geneNbt = tagCompound.func_74775_l("gene");
            Gene gene = Gene.create(geneNbt);
            return new GeneItem(gene);
        }
        return null;
    }

    @Override
    public void writeToItem(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        this.writeToNBT(nbt);
        stack.func_77982_d(nbt);
    }

    @Override
    public int getColor(int renderPass) {
        if (renderPass == 2) {
            return this.getBreedingSystem().getColour();
        }
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getInfo(List<String> list) {
        String chromosomeName = this.getBreedingSystem().getChromosomeName(this.gene.getChromosome());
        list.add(TextFormatting.GOLD + chromosomeName + TextFormatting.GRAY + ": " + this.gene.getName());
    }

    public IBreedingSystem getBreedingSystem() {
        return Binnie.GENETICS.getSystem(this.gene.getSpeciesRoot());
    }

    public IGene getGene() {
        return this.gene;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound geneNBT = this.gene.getNBTTagCompound();
        nbt.func_74782_a("gene", (NBTBase)geneNBT);
        return nbt;
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return this.gene.getSpeciesRoot();
    }

    @Override
    public void addGene(IGene gene) {
        this.gene = gene;
    }
}

