/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.designer.window;

import binnie.core.AbstractMod;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextEdit;
import binnie.core.gui.controls.scroll.ControlScrollableContent;
import binnie.core.gui.events.EventHandler;
import binnie.core.gui.events.EventTextEdit;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.minecraft.MinecraftGUI;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlErrorState;
import binnie.core.gui.minecraft.control.ControlPlayerInventory;
import binnie.core.gui.minecraft.control.ControlSlot;
import binnie.core.gui.window.Panel;
import binnie.core.machines.Machine;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.machines.designer.Designer;
import binnie.extratrees.machines.designer.IDesignerType;
import binnie.extratrees.machines.designer.window.ComponentDesignerRecipe;
import binnie.extratrees.machines.designer.window.ControlRecipeSlot;
import binnie.extratrees.machines.designer.window.ControlTileSelect;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowDesigner
extends Window {
    ControlTextEdit textEdit;
    ControlTileSelect tileSelect;

    public WindowDesigner(EntityPlayer player, IInventory inventory, Side side) {
        super(320, 216, player, inventory, side);
        this.addEventHandler(EventTextEdit.class, EventHandler.Origin.DIRECT_CHILD, this, event -> this.tileSelect.refresh((String)event.getValue()));
    }

    @Nullable
    public static Window create(EntityPlayer player, @Nullable IInventory inventory, Side side) {
        if (inventory == null) {
            return null;
        }
        return new WindowDesigner(player, inventory, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialiseClient() {
        this.setTitle(Machine.getMachine(this.getInventory()).getPackage().getDisplayName());
        new ControlText(this, new Area(190, 36, 114, 10), I18N.localise("binniecore.gui.design"), TextJustification.TOP_CENTER).setColor(0x444444);
        new Panel(this, 188, 48, 118, 126, MinecraftGUI.PanelType.GRAY);
        this.textEdit = new ControlTextEdit(this, 188, 178, 118, 12);
        ControlScrollableContent<ControlTileSelect> scroll = new ControlScrollableContent<ControlTileSelect>(this, 190, 50, 114, 122, 12);
        this.tileSelect = new ControlTileSelect(scroll, 0, 0);
        scroll.setScrollableContent(this.tileSelect);
        new ControlPlayerInventory(this).setPosition(new Point(14, 96));
        new ControlErrorState(this, 76, 65);
        if (this.getInventory() != null) {
            ControlSlot slotWood1 = new ControlSlot.Builder(this, 22, 34).assign(Designer.DESIGN_SLOT_1);
            ControlSlot slotWood2 = new ControlSlot.Builder(this, 62, 34).assign(Designer.DESIGN_SLOT_2);
            ControlSlot slotBeeswax = new ControlSlot.Builder(this, 42, 64).assign(Designer.BEESWAX_SLOT);
            ControlRecipeSlot controlRecipeSlot = new ControlRecipeSlot(this, 112, 34);
        }
    }

    @Override
    protected AbstractMod getMod() {
        return ExtraTrees.instance;
    }

    @Override
    protected String getBackgroundTextureName() {
        return "Woodworker";
    }

    public IDesignerType getDesignerType() {
        return Machine.getInterface(ComponentDesignerRecipe.class, this.getInventory()).getDesignerType();
    }
}

