/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.blocks.property;

import binnie.extratrees.blocks.property.ETWoodTypePredicate;
import binnie.extratrees.wood.EnumETLog;
import binnie.extratrees.wood.PlankType;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import forestry.arboriculture.blocks.PropertyWoodType;
import java.util.Collection;

public class PropertyETWoodType
extends PropertyWoodType<EnumETLog> {
    protected PropertyETWoodType(String name, Class<EnumETLog> valueClass, Collection<EnumETLog> allowedValues) {
        super(name, valueClass, allowedValues);
    }

    public static PropertyETWoodType[] create(String name, int variantsPerBlock) {
        return PropertyETWoodType.create(name, variantsPerBlock, false);
    }

    public static PropertyETWoodType[] create(String name, int variantsPerBlock, boolean isLog) {
        int length = isLog ? EnumETLog.VALUES.length : PlankType.ExtraTreePlanks.VALUES.length;
        int variantCount = (int)Math.ceil((float)length / (float)variantsPerBlock);
        PropertyETWoodType[] variants = new PropertyETWoodType[variantCount];
        for (int variantNumber = 0; variantNumber < variantCount; ++variantNumber) {
            ETWoodTypePredicate filter = new ETWoodTypePredicate(variantNumber, variantsPerBlock, isLog);
            Collection allowedValues = Collections2.filter((Collection)Lists.newArrayList((Object[])EnumETLog.class.getEnumConstants()), (Predicate)filter);
            variants[variantNumber] = new PropertyETWoodType(name, EnumETLog.class, allowedValues);
        }
        return variants;
    }
}

