/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft.control;

import binnie.core.BinnieCore;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITooltip;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.GuiCraftGUI;
import binnie.core.gui.minecraft.MinecraftTooltip;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.TankInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ControlLiquidTank
extends Control
implements ITooltip {
    public static List<Integer> tankError = new ArrayList<Integer>();
    private int tankID = 0;
    private boolean horizontal = false;

    public ControlLiquidTank(IWidget parent, int x, int y) {
        this(parent, x, y, false);
    }

    public ControlLiquidTank(IWidget parent, int x, int y, boolean horizontal) {
        super(parent, x, y, horizontal ? 60 : 18, horizontal ? 18 : 60);
        this.horizontal = horizontal;
        this.addAttribute(Attribute.MOUSE_OVER);
        this.addSelfEventHandler(EventMouse.Down.class, event -> {
            if (event.getButton() == 0) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74774_a("id", (byte)this.tankID);
                ((Window)Window.get(this.getWidget())).sendClientAction("tank-click", nbt);
            }
        });
    }

    public void setTankID(int tank) {
        this.tankID = tank;
    }

    public TankInfo getTank() {
        return ((Window)Window.get(this)).getContainer().getTankInfo(this.tankID);
    }

    public boolean isTankValid() {
        return !this.getTank().isEmpty();
    }

    public int getTankCapacity() {
        return (int)this.getTank().getCapacity();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        int c;
        CraftGUI.RENDER.texture((Object)(this.horizontal ? CraftGUITexture.HORIZONTAL_LIQUID_TANK : CraftGUITexture.LIQUID_TANK), Point.ZERO);
        GuiCraftGUI gui = ((Window)Window.get(this)).getGui();
        if (this.isMouseOver() && gui.isHelpMode()) {
            c = -1442840576 + MinecraftTooltip.getOutline(Tooltip.Type.HELP);
            RenderUtil.drawGradientRect(this.getArea().inset(1), c, c);
        } else if (tankError.contains(this.tankID)) {
            c = -1442840576 + MinecraftTooltip.getOutline(MinecraftTooltip.Type.ERROR);
            RenderUtil.drawGradientRect(this.getArea().inset(1), c, c);
        } else if (this.getTopParent().getMousedOverWidget() == this) {
            if (!gui.getDraggedItem().func_190926_b()) {
                RenderUtil.drawGradientRect(this.getArea().inset(1), -1426089575, -1426089575);
            } else {
                RenderUtil.drawGradientRect(this.getArea().inset(1), -2130706433, -2130706433);
            }
        }
        if (this.isTankValid()) {
            int height = this.horizontal ? 16 : 58;
            int squaled = Math.round((float)height * (this.getTank().getAmount() / this.getTank().getCapacity()));
            int yPos = height + 1;
            Fluid fluid = this.getTank().liquid.getFluid();
            int hex = fluid.getColor(this.getTank().liquid);
            int r = (hex & 0xFF0000) >> 16;
            int g = (hex & 0xFF00) >> 8;
            int b = hex & 0xFF;
            GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            Point pos = this.getAbsolutePosition();
            Point offset = new Point(0, height - squaled);
            Area limited = this.getArea().inset(1);
            if (this.horizontal) {
                limited.setSize(new Point(limited.width() - 1, limited.height()));
            }
            CraftGUI.RENDER.limitArea(new Area(limited.pos().add(pos).add(offset), limited.size().sub(offset)), guiWidth, guiHeight);
            GL11.glEnable((int)3089);
            BinnieCore.getBinnieProxy().bindTexture(TextureMap.field_110575_b);
            for (int y = 0; y < height; y += 16) {
                for (int x = 0; x < (this.horizontal ? 58 : 16); x += 16) {
                    TextureAtlasSprite icon = BinnieCore.getBinnieProxy().getTextureAtlasSprite(fluid.getStill());
                    RenderUtil.drawSprite(new Point(1 + x, 1 + y), icon);
                }
            }
            GL11.glDisable((int)3089);
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderForeground(int guiWidth, int guiHeight) {
        Area area;
        CraftGUI.RENDER.texture((Object)(this.horizontal ? CraftGUITexture.HORIZONTAL_LIQUID_TANK_OVERLAY : CraftGUITexture.LIQUID_TANK_OVERLAY), Point.ZERO);
        GuiCraftGUI gui = ((Window)Window.get(this)).getGui();
        if (this.isMouseOver() && gui.isHelpMode()) {
            area = this.getArea();
            RenderUtil.setColour(MinecraftTooltip.getOutline(Tooltip.Type.HELP));
            CraftGUI.RENDER.texture((Object)CraftGUITexture.OUTLINE, area.outset(1));
        }
        if (tankError.contains(this.tankID)) {
            area = this.getArea();
            RenderUtil.setColour(MinecraftTooltip.getOutline(MinecraftTooltip.Type.ERROR));
            CraftGUI.RENDER.texture((Object)CraftGUITexture.OUTLINE, area.outset(1));
        }
    }

    @Override
    public void getHelpTooltip(Tooltip tooltip) {
        if (this.getTankSlot() != null) {
            TankSlot slot = this.getTankSlot();
            tooltip.add(slot.getName());
            tooltip.add("Capacity: " + this.getTankCapacity() + " mB");
            tooltip.add("Insert Side: " + MachineSide.asString(slot.getInputSides()));
            tooltip.add("Extract Side: " + MachineSide.asString(slot.getOutputSides()));
            if (slot.isReadOnly()) {
                tooltip.add("Output Only Tank");
            }
            tooltip.add("Accepts: " + (slot.getValidator() == null ? "Any Item" : slot.getValidator().getTooltip()));
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        if (this.isTankValid()) {
            int percentage = (int)(100.0 * (double)this.getTank().getAmount() / (double)this.getTankCapacity());
            tooltip.add(this.getTank().getName());
            tooltip.add(percentage + "% full");
            tooltip.add((int)this.getTank().getAmount() + " mB");
            return;
        }
        tooltip.add("Empty");
    }

    @Nullable
    private TankSlot getTankSlot() {
        ITankMachine tank = Machine.getInterface(ITankMachine.class, ((Window)Window.get(this)).getInventory());
        return tank != null ? tank.getTankSlot(this.tankID) : null;
    }
}

