/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.fieldkit;

import binnie.core.Binnie;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITooltip;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.events.EventValueChanged;
import binnie.core.gui.events.EventWidget;
import binnie.core.gui.fieldkit.ControlChromosome;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.resource.Texture;
import binnie.core.gui.resource.minecraft.StandardTexture;
import binnie.core.texture.BinnieCoreTexture;
import forestry.api.genetics.IChromosomeType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlChromoPicker
extends Control
implements ITooltip {
    Texture Selected = new StandardTexture(160, 18, 16, 16, BinnieCoreTexture.GUI_PUNNETT);
    Texture Texture = new StandardTexture(160, 34, 16, 16, BinnieCoreTexture.GUI_PUNNETT);
    IChromosomeType type;
    ControlChromosome parent;

    public ControlChromoPicker(ControlChromosome parent, int x, int y, IChromosomeType chromo) {
        super(parent, x, y, 16, 16);
        this.type = chromo;
        this.addAttribute(Attribute.MOUSE_OVER);
        this.parent = parent;
        this.addSelfEventHandler(EventWidget.StartMouseOver.class, event -> this.callEvent(new EventValueChanged<IChromosomeType>(this.getWidget(), this.type)));
        this.addSelfEventHandler(EventWidget.EndMouseOver.class, event -> this.callEvent(new EventValueChanged<Object>(this.getWidget(), null)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        super.onRenderBackground(guiWidth, guiHeight);
        boolean selected = this.isMouseOver();
        Texture text = selected ? this.Selected : this.Texture;
        CraftGUI.RENDER.texture(text, Point.ZERO);
    }

    @Override
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        tooltip.add(Binnie.GENETICS.getSystem(this.parent.getRoot()).getChromosomeName(this.type));
    }
}

