/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui;

import binnie.core.AbstractMod;
import binnie.core.gui.IBinnieGUID;
import binnie.core.gui.minecraft.Window;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class BinnieGUIHandler
implements IGuiHandler {
    private AbstractMod mod;

    public BinnieGUIHandler(AbstractMod mod) {
        this.mod = mod;
    }

    @Nullable
    public final Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        Window window = this.getWindow(id, player, world, x, y, z, Side.SERVER);
        if (window == null) {
            return null;
        }
        window.initialiseServer();
        return window.getContainer();
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public final Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            return this.getServerGuiElement(id, player, world, x, y, z);
        }
        Window window = this.getWindow(id, player, world, x, y, z, Side.CLIENT);
        if (window == null) {
            return null;
        }
        return window.getGui();
    }

    @Nullable
    public Window getWindow(int id, EntityPlayer player, World world, int x, int y, int z, Side side) {
        for (IBinnieGUID guid : this.mod.getGUIDs()) {
            if (guid.ordinal() != id) continue;
            return guid.getWindow(player, world, x, y, z, side);
        }
        return null;
    }
}

