/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines;

import binnie.core.machines.IMachineType;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IInteraction;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.machines.ModuleMachine;
import binnie.extratrees.machines.brewery.BreweryMachine;
import binnie.extratrees.machines.designer.Designer;
import binnie.extratrees.machines.distillery.DistilleryMachine;
import binnie.extratrees.machines.fruitpress.FruitPressMachine;
import binnie.extratrees.machines.lumbermill.LumbermillMachine;
import binnie.extratrees.machines.nursery.Nursery;
import binnie.modules.ModuleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum ExtraTreeMachine implements IMachineType
{
    Lumbermill(LumbermillMachine.class),
    Woodworker(Designer.PackageWoodworker.class),
    Panelworker(Designer.PackagePanelworker.class),
    Nursery(Nursery.PackageNursery.class),
    Press(FruitPressMachine.class),
    BREWERY(BreweryMachine.class),
    Distillery(DistilleryMachine.class),
    Glassworker(Designer.PackageGlassworker.class),
    Tileworker(Designer.PackageTileworker.class);

    Class<? extends MachinePackage> clss;

    private ExtraTreeMachine(Class<? extends MachinePackage> clss) {
        this.clss = clss;
    }

    @Override
    public Class<? extends MachinePackage> getPackageClass() {
        return this.clss;
    }

    @Override
    public boolean isActive() {
        if (this == Tileworker) {
            return ModuleManager.isModuleEnabled("botany", "botany.ceramic");
        }
        if (this == Glassworker || this == Woodworker || this == Panelworker) {
            return ModuleManager.isModuleEnabled("extratrees", "extratrees.carpentry");
        }
        return this != Nursery;
    }

    public ItemStack get(int i) {
        return new ItemStack(ModuleMachine.blockMachine, i, this.ordinal());
    }

    public static abstract class PackageExtraTreeMachine
    extends MachinePackage {
        protected PackageExtraTreeMachine(String uid, boolean powered) {
            super(uid, powered);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }

    public static class ComponentExtraTreeGUI
    extends MachineComponent
    implements IInteraction.RightClick {
        ExtraTreesGUID id;

        public ComponentExtraTreeGUI(Machine machine, ExtraTreesGUID id) {
            super(machine);
            this.id = id;
        }

        @Override
        public void onRightClick(World p0, EntityPlayer p1, BlockPos pos) {
            ExtraTrees.proxy.openGui(this.id, p1, pos);
        }
    }
}

