/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.kitchen.craftgui;

import binnie.core.gui.Attribute;
import binnie.core.gui.ITooltip;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.Widget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.renderer.RenderUtil;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlFluidDisplay
extends Control
implements ITooltip {
    @Nullable
    private FluidStack fluidStack = null;
    private boolean hastooltip = false;

    public ControlFluidDisplay(IWidget parent, int x, int y) {
        this(parent, x, y, 16);
    }

    public ControlFluidDisplay(IWidget parent, int x, int y, FluidStack stack, boolean tooltip) {
        this(parent, x, y, 16);
        this.setFluidStack(stack);
        if (tooltip) {
            this.setTooltip();
        }
    }

    public ControlFluidDisplay(IWidget parent, int x, int y, int size) {
        super(parent, x, y, size, size);
    }

    public void setTooltip() {
        this.hastooltip = true;
        this.addAttribute(Attribute.MOUSE_OVER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderForeground(int guiWidth, int guiHeight) {
        if (this.fluidStack == null) {
            return;
        }
        Point relativeToWindow = this.getAbsolutePosition().sub(this.getTopParent().getPosition());
        if (relativeToWindow.xPos() > ((Widget)Window.get(this)).getSize().xPos() + 100 || relativeToWindow.yPos() > ((Widget)Window.get(this)).getSize().yPos() + 100) {
            return;
        }
        if (this.fluidStack != null) {
            Fluid fluid = this.fluidStack.getFluid();
            int hex = fluid.getColor(this.fluidStack);
            int r = (hex & 0xFF0000) >> 16;
            int g = (hex & 0xFF00) >> 8;
            int b = hex & 0xFF;
            ResourceLocation iconRL = this.fluidStack.getFluid().getStill();
            TextureAtlasSprite icon = FMLClientHandler.instance().getClient().func_147117_R().func_110572_b(iconRL.toString());
            GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            if (this.getSize().xPos() != 16) {
                GlStateManager.func_179094_E();
                float scale = (float)this.getSize().xPos() / 16.0f;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                RenderUtil.drawSprite(Point.ZERO, icon);
                GlStateManager.func_179121_F();
            } else {
                RenderUtil.drawSprite(Point.ZERO, icon);
            }
            GlStateManager.func_179084_k();
        }
    }

    public void setFluidStack(@Nullable FluidStack fluidStack) {
        this.fluidStack = fluidStack;
    }

    @Override
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        if (this.hastooltip && this.fluidStack != null) {
            tooltip.add(this.fluidStack.getLocalizedName());
        }
    }
}

