/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.tile;

import binnie.botany.ceramic.brick.CeramicBrickPair;
import binnie.botany.ceramic.brick.CeramicBrickType;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.modules.ModuleCeramic;
import binnie.core.block.TileEntityMetadata;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileCeramicBrick
extends TileEntity {
    private EnumFlowerColor colorFirst = EnumFlowerColor.Black;
    private EnumFlowerColor colorSecond = EnumFlowerColor.White;

    public void setColors(EnumFlowerColor colorFirst, EnumFlowerColor colorSecond) {
        this.colorFirst = colorFirst;
        this.colorSecond = colorSecond;
    }

    public boolean hasTwoColors() {
        return CeramicBrickType.VALUES[this.func_145832_p()].canDouble() && this.colorSecond != this.colorFirst;
    }

    public ItemStack getStack(int i) {
        ItemStack s = TileEntityMetadata.getItemStack(ModuleCeramic.ceramicBrick, this.ordinal());
        s.func_190920_e(i);
        return s;
    }

    public int ordinal() {
        return this.colorFirst.ordinal() + this.colorSecond.ordinal() * 256 + this.func_145832_p() * 256 * 256;
    }

    public CeramicBrickPair pair() {
        return new CeramicBrickPair(this.colorFirst, this.colorSecond, CeramicBrickType.VALUES[this.func_145832_p()]);
    }

    public EnumFlowerColor getColorFirst() {
        return this.colorFirst;
    }

    public EnumFlowerColor getColorSecond() {
        return this.colorSecond;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("First", this.colorFirst.ordinal());
        compound.func_74768_a("Second", this.colorSecond.ordinal());
        return super.func_189515_b(compound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("First")) {
            this.colorFirst = EnumFlowerColor.VALUES[compound.func_74762_e("First")];
        }
        if (compound.func_74764_b("Second")) {
            this.colorSecond = EnumFlowerColor.VALUES[compound.func_74762_e("Second")];
        }
    }
}

