/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics;

import binnie.botany.api.genetics.EnumFlowerChromosome;
import binnie.botany.api.genetics.EnumFlowerStage;
import binnie.botany.api.genetics.IAlleleFlowerSpecies;
import binnie.botany.api.genetics.IBotanistTracker;
import binnie.botany.api.genetics.IColorMix;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerGenome;
import binnie.botany.api.genetics.IFlowerMutation;
import binnie.botany.api.genetics.IFlowerRoot;
import binnie.botany.genetics.BotanistTracker;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.genetics.Flower;
import binnie.botany.genetics.FlowerAlyzerPlugin;
import binnie.botany.genetics.FlowerDefinition;
import binnie.botany.genetics.FlowerGenome;
import binnie.botany.items.ItemFlowerGE;
import binnie.botany.modules.ModuleFlowers;
import binnie.botany.tile.TileEntityFlower;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesType;
import forestry.core.genetics.SpeciesRoot;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class FlowerRoot
extends SpeciesRoot
implements IFlowerRoot {
    static final String UID = "rootFlowers";
    public static int flowerSpeciesCount = -1;
    public static ArrayList<IFlower> flowerTemplates = new ArrayList();
    private static ArrayList<IFlowerMutation> flowerMutations = new ArrayList();
    private static ArrayList<IColorMix> colourMixes = new ArrayList();
    Map<ItemStack, IFlower> conversions = new HashMap<ItemStack, IFlower>();

    public String getUID() {
        return UID;
    }

    public int getSpeciesCount() {
        if (flowerSpeciesCount < 0) {
            flowerSpeciesCount = 0;
            for (Map.Entry entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                if (!(entry.getValue() instanceof IAlleleFlowerSpecies) || !((IAlleleFlowerSpecies)entry.getValue()).isCounted()) continue;
                ++flowerSpeciesCount;
            }
        }
        return flowerSpeciesCount;
    }

    public boolean isMember(ItemStack stack) {
        return !stack.func_190926_b() && this.getType(stack) != null;
    }

    public boolean isMember(ItemStack stack, ISpeciesType type) {
        return this.getType(stack) == type;
    }

    public boolean isMember(IIndividual individual) {
        return individual instanceof IFlower;
    }

    public IAlyzerPlugin getAlyzerPlugin() {
        return FlowerAlyzerPlugin.INSTANCE;
    }

    public ISpeciesType getIconType() {
        return EnumFlowerStage.FLOWER;
    }

    @Override
    @Nullable
    public EnumFlowerStage getType(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (ModuleFlowers.flowerItem == item) {
            return EnumFlowerStage.SEED;
        }
        if (ModuleFlowers.pollen == item) {
            return EnumFlowerStage.POLLEN;
        }
        if (ModuleFlowers.seed == item) {
            return EnumFlowerStage.SEED;
        }
        return null;
    }

    public ItemStack getMemberStack(IIndividual flower, ISpeciesType type) {
        if (!this.isMember(flower)) {
            return ItemStack.field_190927_a;
        }
        ItemFlowerGE flowerItem = ModuleFlowers.flowerItem;
        if (type == EnumFlowerStage.SEED) {
            flowerItem = ModuleFlowers.seed;
        } else if (type == EnumFlowerStage.POLLEN) {
            flowerItem = ModuleFlowers.pollen;
        }
        if (flowerItem != ModuleFlowers.flowerItem) {
            ((IFlower)flower).setAge(0);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        flower.writeToNBT(nbttagcompound);
        ItemStack flowerStack = new ItemStack((Item)flowerItem);
        flowerStack.func_77982_d(nbttagcompound);
        return flowerStack;
    }

    @Override
    @Nullable
    public IFlower getMember(ItemStack stack) {
        if (!this.isMember(stack) || stack.func_77978_p() == null) {
            return null;
        }
        return new Flower(stack.func_77978_p());
    }

    @Override
    public IFlower getFlower(IFlowerGenome genome) {
        return new Flower(genome, 2);
    }

    @Override
    public IFlowerGenome templateAsGenome(IAllele[] template) {
        return new FlowerGenome(this.templateAsChromosomes(template));
    }

    @Override
    public IFlowerGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new FlowerGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }

    @Override
    public IFlower templateAsIndividual(IAllele[] template) {
        return new Flower(this.templateAsGenome(template), 2);
    }

    @Override
    public IFlower templateAsIndividual(IAllele[] templateActive, IAllele[] templateInactive) {
        return new Flower(this.templateAsGenome(templateActive, templateInactive), 2);
    }

    public ArrayList<IFlower> getIndividualTemplates() {
        return flowerTemplates;
    }

    public void registerTemplate(IAllele[] template) {
        this.registerTemplate(template[0].getUID(), template);
    }

    public void registerTemplate(String identifier, IAllele[] template) {
        flowerTemplates.add(new Flower(this.templateAsGenome(template), 2));
        if (!this.speciesTemplates.containsKey(identifier)) {
            this.speciesTemplates.put(identifier, template);
        }
    }

    public IAllele[] getTemplate(String identifier) {
        return (IAllele[])this.speciesTemplates.get(identifier);
    }

    public IAllele[] getDefaultTemplate() {
        IAllele[] alleles = new IAllele[EnumFlowerChromosome.values().length];
        AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SPECIES, (IAllele)FlowerDefinition.Poppy.getSpecies());
        AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PRIMARY, (IAllele)EnumFlowerColor.Red.getFlowerColorAllele());
        AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SECONDARY, (IAllele)EnumFlowerColor.Red.getFlowerColorAllele());
        AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.EFFECT, (IAllele)ModuleFlowers.alleleEffectNone);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.AVERAGE);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.Green.getFlowerColorAllele());
        return alleles;
    }

    public IAllele[] getRandomTemplate(Random rand) {
        return ((IAllele[][])this.speciesTemplates.values().toArray((T[])new IAllele[0][]))[rand.nextInt(this.speciesTemplates.values().size())];
    }

    public ArrayList<IFlowerMutation> getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(flowerMutations);
        }
        return flowerMutations;
    }

    public void registerMutation(IMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        flowerMutations.add((IFlowerMutation)mutation);
    }

    @Override
    public IBotanistTracker getBreedingTracker(World world, @Nullable GameProfile player) {
        String filename = "BotanistTracker." + (player == null ? "common" : player.getId());
        BotanistTracker tracker = (BotanistTracker)world.func_72943_a(BotanistTracker.class, filename);
        if (tracker == null) {
            tracker = new BotanistTracker(filename);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        return tracker;
    }

    public IIndividual getMember(NBTTagCompound compound) {
        return new Flower(compound);
    }

    public Class<IFlower> getMemberClass() {
        return IFlower.class;
    }

    public IChromosomeType[] getKaryotype() {
        return EnumFlowerChromosome.values();
    }

    public IChromosomeType getSpeciesChromosomeType() {
        return EnumFlowerChromosome.SPECIES;
    }

    @Override
    public void addConversion(ItemStack itemstack, IAllele[] template) {
        IFlower flower = this.getFlower(this.templateAsGenome(template));
        this.conversions.put(itemstack, flower);
    }

    @Override
    @Nullable
    public IFlower getConversion(ItemStack itemstack) {
        for (Map.Entry<ItemStack, IFlower> entry : this.conversions.entrySet()) {
            if (!entry.getKey().func_77969_a(itemstack)) continue;
            return (IFlower)entry.getValue().copy();
        }
        return null;
    }

    @Override
    public void registerColourMix(IColorMix colorMix) {
        colourMixes.add(colorMix);
    }

    @Override
    public Collection<IColorMix> getColorMixes(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(colourMixes);
        }
        return colourMixes;
    }

    @Override
    public boolean plant(World world, BlockPos pos, IFlower flower, GameProfile owner) {
        boolean set = world.func_175656_a(pos, ModuleFlowers.flower.func_176223_P());
        if (!set) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        TileEntity below = world.func_175625_s(pos.func_177977_b());
        if (tile != null && tile instanceof TileEntityFlower) {
            TileEntityFlower tileFlower = (TileEntityFlower)tile;
            if (below instanceof TileEntityFlower) {
                tileFlower.setSection(((TileEntityFlower)below).getSection());
            } else {
                tileFlower.create(flower, owner);
            }
        }
        this.tryGrowSection(world, pos);
        return true;
    }

    @Override
    public void tryGrowSection(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileFlower = world.func_175625_s(pos);
        if (tileFlower == null || !(tileFlower instanceof TileEntityFlower)) {
            return;
        }
        IFlower flower = ((TileEntityFlower)tileFlower).getFlower();
        int section = ((TileEntityFlower)tileFlower).getSection();
        if (flower == null || section >= flower.getGenome().getPrimary().getType().getSections() - 1 || flower.getAge() <= 0) {
            return;
        }
        world.func_175656_a(pos.func_177984_a(), ModuleFlowers.flower.func_176223_P());
        TileEntity flowerAbove = world.func_175625_s(pos.func_177984_a());
        if (flowerAbove != null && flowerAbove instanceof TileEntityFlower) {
            ((TileEntityFlower)flowerAbove).setSection(section + 1);
        }
    }

    @Override
    public void onGrowFromSeed(World world, BlockPos pos) {
        this.tryGrowSection(world, pos);
    }
}

