/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.farming;

import binnie.Binnie;
import binnie.botany.api.gardening.EnumAcidity;
import binnie.botany.api.gardening.EnumFertiliserType;
import binnie.botany.api.gardening.EnumMoisture;
import binnie.botany.api.gardening.EnumSoilType;
import binnie.botany.api.gardening.IBlockSoil;
import binnie.botany.api.gardening.IGardeningManager;
import binnie.botany.core.BotanyCore;
import binnie.botany.farming.FarmLogic;
import binnie.botany.farming.FarmableFlower;
import binnie.botany.farming.FarmableVanillaFlower;
import binnie.botany.modules.ModuleGardening;
import binnie.botany.tile.TileEntityFlower;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.owner.IOwnedTile;
import forestry.core.utils.BlockUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class GardenLogic
extends FarmLogic {
    List<IFarmable> farmables;
    private EnumMoisture moisture;
    @Nullable
    private EnumAcidity acidity;
    private boolean fertilised;
    private String name;
    private NonNullList<ItemStack> produce;
    private ItemStack icon;

    public GardenLogic(EnumMoisture moisture, @Nullable EnumAcidity acidity, boolean isManual, boolean isFertilised, ItemStack icon, String name) {
        this.isManual = isManual;
        this.moisture = moisture;
        this.acidity = acidity;
        this.fertilised = isFertilised;
        this.icon = icon;
        this.name = name;
        this.produce = NonNullList.func_191196_a();
        this.farmables = new ArrayList<IFarmable>();
        this.farmables.add(new FarmableFlower());
        this.farmables.add(new FarmableVanillaFlower());
    }

    public int getFertilizerConsumption() {
        return this.fertilised ? 8 : 2;
    }

    public int getWaterConsumption(float hydrationModifier) {
        return (int)((float)(this.moisture.ordinal() * 40) * hydrationModifier);
    }

    public boolean isAcceptedResource(ItemStack itemstack) {
        IGardeningManager gardening = BotanyCore.getGardening();
        return gardening.isSoil(itemstack.func_77973_b()) || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m) || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d) || gardening.isFertiliser(EnumFertiliserType.ACID, itemstack) || gardening.isFertiliser(EnumFertiliserType.ALKALINE, itemstack);
    }

    public NonNullList<ItemStack> collect(World world, IFarmHousing farmHousing) {
        NonNullList<ItemStack> products = this.produce;
        this.produce = NonNullList.func_191196_a();
        return products;
    }

    public boolean cultivate(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        return this.maintainSoil(world, pos, direction, extent, farmHousing) || !this.isManual && this.maintainWater(world, pos, direction, extent, farmHousing) || this.maintainCrops(world, pos.func_177984_a(), direction, extent, farmHousing);
    }

    private boolean isWaste(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d);
    }

    private boolean maintainSoil(World world, BlockPos pos, FarmDirection direction, int extent, IFarmHousing housing) {
        IGardeningManager gardening = BotanyCore.getGardening();
        for (int i = 0; i < extent; ++i) {
            IBlockSoil soil;
            BlockPos position = pos.func_177967_a(direction.getFacing(), i);
            if (this.fertilised && gardening.isSoil(this.getBlock(world, position)) && (soil = (IBlockSoil)this.getBlock(world, position)).fertilise(world, position, EnumSoilType.FLOWERBED)) continue;
            if (this.getBlock(world, position.func_177984_a()) == ModuleGardening.plant) {
                world.func_175698_g(position.func_177984_a());
                continue;
            }
            if (this.acidity != null && gardening.isSoil(this.getBlock(world, position))) {
                NonNullList resources;
                ItemStack stack;
                soil = (IBlockSoil)this.getBlock(world, position);
                EnumAcidity pH = soil.getPH(world, position);
                if (pH.ordinal() < this.acidity.ordinal() && !(stack = this.getAvailableFertiliser(housing, EnumFertiliserType.ALKALINE)).func_190926_b() && soil.setPH(world, position, EnumAcidity.values()[pH.ordinal() + 1])) {
                    resources = NonNullList.func_191196_a();
                    resources.add((Object)stack);
                    housing.getFarmInventory().removeResources(resources);
                    continue;
                }
                if (pH.ordinal() > this.acidity.ordinal() && !(stack = this.getAvailableFertiliser(housing, EnumFertiliserType.ACID)).func_190926_b() && soil.setPH(world, position, EnumAcidity.values()[pH.ordinal() - 1])) {
                    resources = NonNullList.func_191196_a();
                    resources.add((Object)stack);
                    housing.getFarmInventory().removeResources(resources);
                    continue;
                }
            }
            if (!this.isAirBlock(world, position) && !BlockUtil.isReplaceableBlock((IBlockState)this.getBlockState(world, position), (World)world, (BlockPos)position)) {
                ItemStack block = this.getAsItemStack(world, position);
                ItemStack loam = this.getAvailableLoam(housing);
                if (!this.isWaste(block) || loam.func_190926_b()) continue;
                IBlockState blockState = Block.func_149634_a((Item)block.func_77973_b()).func_176203_a(block.func_77952_i());
                Blocks.field_150346_d.getDrops(this.produce, (IBlockAccess)world, position, blockState, 0);
                this.setBlock(world, position, Blocks.field_150350_a, 0);
                return this.trySetSoil(world, position, loam, housing);
            }
            if (this.isManual || this.isWaterBlock(world, position)) continue;
            if (i % 2 == 0) {
                return this.trySetSoil(world, position, housing);
            }
            FarmDirection cclock = FarmDirection.EAST;
            if (direction == FarmDirection.EAST) {
                cclock = FarmDirection.SOUTH;
            } else if (direction == FarmDirection.SOUTH) {
                cclock = FarmDirection.EAST;
            } else if (direction == FarmDirection.WEST) {
                cclock = FarmDirection.SOUTH;
            }
            BlockPos previous = position.func_177972_a(cclock.getFacing());
            ItemStack soil2 = this.getAsItemStack(world, previous);
            if (gardening.isSoil(soil2.func_77973_b())) continue;
            this.trySetSoil(world, position, housing);
        }
        return false;
    }

    private boolean maintainWater(World world, BlockPos pos, FarmDirection direction, int extent, IFarmHousing housing) {
        for (int i = 0; i < extent; ++i) {
            BlockPos position = pos.func_177967_a(direction.getFacing(), i);
            if (!this.isAirBlock(world, position) && !BlockUtil.isReplaceableBlock((IBlockState)this.getBlockState(world, position), (World)world, (BlockPos)position) || this.isWaterBlock(world, position)) continue;
            boolean isEnclosed = true;
            if (world.func_175623_d(position.func_177974_f())) {
                isEnclosed = false;
            } else if (world.func_175623_d(position.func_177976_e())) {
                isEnclosed = false;
            } else if (world.func_175623_d(position.func_177968_d())) {
                isEnclosed = false;
            } else if (world.func_175623_d(position.func_177978_c())) {
                isEnclosed = false;
            }
            boolean bl = isEnclosed = isEnclosed || this.moisture != EnumMoisture.DAMP;
            if (!isEnclosed) continue;
            return this.trySetWater(world, position, housing);
        }
        return false;
    }

    private ItemStack getAvailableLoam(IFarmHousing housing) {
        EnumMoisture[] moistures = this.moisture == EnumMoisture.DAMP ? new EnumMoisture[]{EnumMoisture.DAMP, EnumMoisture.NORMAL, EnumMoisture.DRY} : (this.moisture == EnumMoisture.DRY ? new EnumMoisture[]{EnumMoisture.DRY, EnumMoisture.DAMP, EnumMoisture.DRY} : new EnumMoisture[]{EnumMoisture.DRY, EnumMoisture.NORMAL, EnumMoisture.DAMP});
        EnumAcidity[] acidities = new EnumAcidity[]{EnumAcidity.NEUTRAL, EnumAcidity.ACID, EnumAcidity.ALKALINE};
        for (EnumMoisture moist : moistures) {
            for (EnumAcidity acid : acidities) {
                for (Block type : new Block[]{ModuleGardening.flowerbed, ModuleGardening.loam, ModuleGardening.soil}) {
                    int meta = acid.ordinal() * 3 + moist.ordinal();
                    NonNullList resources = NonNullList.func_191196_a();
                    ItemStack resourceStack = new ItemStack(type, 1, meta);
                    resources.add((Object)resourceStack);
                    if (!housing.getFarmInventory().hasResources(resources)) continue;
                    return resourceStack;
                }
            }
        }
        NonNullList resources = NonNullList.func_191196_a();
        ItemStack resourceStack = new ItemStack(Blocks.field_150346_d);
        resources.add((Object)resourceStack);
        if (housing.getFarmInventory().hasResources(resources)) {
            return new ItemStack(Blocks.field_150346_d);
        }
        return ItemStack.field_190927_a;
    }

    private boolean trySetSoil(World world, BlockPos position, IFarmHousing housing) {
        return this.trySetSoil(world, position, this.getAvailableLoam(housing), housing);
    }

    private boolean trySetSoil(World world, BlockPos position, ItemStack loam, IFarmHousing housing) {
        ItemStack copy = loam;
        if (loam.func_190926_b()) {
            return false;
        }
        if (loam.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d)) {
            loam = new ItemStack((Block)ModuleGardening.soil, 1, 4);
        }
        this.setBlock(world, position, ((ItemBlock)loam.func_77973_b()).func_179223_d(), loam.func_77952_i());
        NonNullList resources = NonNullList.func_191196_a();
        resources.add((Object)copy);
        housing.getFarmInventory().removeResources(resources);
        return true;
    }

    private boolean trySetWater(World world, BlockPos position, IFarmHousing housing) {
        FluidStack water = Binnie.LIQUID.getFluidStack("water", 1000);
        if (this.moisture == EnumMoisture.DAMP) {
            if (water == null || !housing.hasLiquid(water)) {
                return false;
            }
            this.setBlock(world, position, (Block)Blocks.field_150355_j, 0);
            housing.removeLiquid(water);
            return true;
        }
        if (this.moisture != EnumMoisture.DRY) {
            return this.trySetSoil(world, position, housing);
        }
        ItemStack sand = new ItemStack((Block)Blocks.field_150354_m, 1);
        NonNullList resources = NonNullList.func_191196_a();
        resources.add((Object)sand);
        if (!housing.getFarmInventory().hasResources(resources)) {
            return false;
        }
        this.setBlock(world, position, (Block)Blocks.field_150354_m, 0);
        housing.getFarmInventory().removeResources(resources);
        return true;
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
    }

    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable farmable : this.farmables) {
            if (!farmable.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    public Collection<ICrop> harvest(World world, BlockPos pos, FarmDirection direction, int extent) {
        if (this.isManual) {
            return Collections.emptyList();
        }
        return this.farmables.stream().map(farmable -> farmable.getCropAt(world, pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ResourceLocation getTextureMap() {
        return TextureMap.field_110575_b;
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getIconItemStack() {
        return this.icon;
    }

    protected boolean maintainCrops(World world, BlockPos pos, FarmDirection direction, int extent, IFarmHousing housing) {
        IGardeningManager gardening = BotanyCore.getGardening();
        for (int i = 0; i < extent; ++i) {
            ItemStack below;
            BlockPos position = pos.func_177967_a(direction.getFacing(), i);
            if (!this.isAirBlock(world, position) && !BlockUtil.isReplaceableBlock((IBlockState)this.getBlockState(world, position), (World)world, (BlockPos)position) || !gardening.isSoil((below = this.getAsItemStack(world, position.func_177977_b())).func_77973_b())) continue;
            return this.trySetCrop(world, position, housing);
        }
        return false;
    }

    private boolean trySetCrop(World world, BlockPos position, IFarmHousing housing) {
        for (IFarmable farmable : this.farmables) {
            TileEntity tile;
            if (!housing.plantGermling(farmable, world, position)) continue;
            if (housing instanceof IOwnedTile && (tile = world.func_175625_s(position)) instanceof TileEntityFlower) {
                TileEntityFlower flower = (TileEntityFlower)tile;
                IOwnedTile owned = (IOwnedTile)housing;
                flower.setOwner(owned.getOwnerHandler().getOwner());
            }
            return true;
        }
        return false;
    }

    public ItemStack getAvailableFertiliser(IFarmHousing housing, EnumFertiliserType type) {
        for (ItemStack stack : BotanyCore.getGardening().getFertilisers(type)) {
            if (stack.func_190926_b()) continue;
            NonNullList resources = NonNullList.func_191196_a();
            resources.add((Object)stack);
            if (!housing.getFarmInventory().hasResources(resources)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

