package binnie.extratrees.machines.lumbermill.window;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.MinecraftGUI;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlProgressBase;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.Texture;
import binnie.core.gui.resource.minecraft.StandardTexture;
import binnie.core.gui.window.Panel;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.machines.lumbermill.LumbermillMachine;
import binnie.extratrees.machines.lumbermill.recipes.LumbermillRecipeManager;

public class ControlLumbermillProgress extends ControlProgressBase {
	static final Texture SAW = new StandardTexture(0, 0, 6, 32, ExtraTreeTexture.GUI);
	static final Texture SAW_2 = new StandardTexture(2, 0, 4, 32, ExtraTreeTexture.GUI);
	float oldProgress;
	float animation;

	protected ControlLumbermillProgress(final IWidget parent, final int x, final int y) {
		super(parent, x, y, 66, 18);
		this.oldProgress = 0;
		this.animation = 0;
		new Panel(this, 0, 0, 66, 18, MinecraftGUI.PanelType.BLACK);
	}

	@Override
	public void onUpdateClient() {
		super.onUpdateClient();
		if (this.oldProgress != this.progress) {
			this.oldProgress = this.progress;
			this.animation += 5;
		}
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void onRenderForeground(int guiWidth, int guiHeight) {
		GlStateManager.func_179140_f();
		final int sawX = (int) (63 * this.progress);
		CraftGUI.RENDER.texture(ControlLumbermillProgress.SAW, new Point(sawX, -8 + Math.round(6 * (float) Math.sin(this.animation))));
		final ItemStack item = Window.get(this).getInventory().func_70301_a(LumbermillMachine.SLOT_LOG);
		if (item.func_190926_b()) {
			return;
		}
		GlStateManager.func_179140_f();
		Block block = null;
		if (item.func_77973_b() instanceof ItemBlock) {
			block = ((ItemBlock) item.func_77973_b()).func_179223_d();
		}
		if (block == null) {
			return;
		}
		//TODO RENDERING
		//final IIcon icon = block.getIcon(2, item.getItemDamage());
		TextureAtlasSprite icon = getWoodSprite(item);
		for (int i = 0; i < 4; ++i) {
			//CraftGUI.Render.iconBlock(new IPoint(1 + i * 16, 1), icon);
			RenderUtil.drawSprite(new Point(1 + i * 16, 1), icon);
		}
		final ItemStack result = LumbermillRecipeManager.getPlankProduct(item);
		if (result == null) {
			return;
		}
		Block block2 = null;
		if (result.func_77973_b() instanceof ItemBlock) {
			block2 = ((ItemBlock) result.func_77973_b()).func_179223_d();
		}
		if (block2 == null) {
			return;
		}
		//final IIcon icon2 = block2.getIcon(2, result.getItemDamage());
		TextureAtlasSprite sprite = getWoodSprite(result);
		final Point pos = this.getAbsolutePosition();
		CraftGUI.RENDER.limitArea(new Area(pos.add(Point.ZERO), new Point(Math.round(this.progress * 64) + 2, 18)), guiWidth, guiHeight);
		GL11.glEnable(GL11.GL_SCISSOR_TEST);
		for (int j = 0; j < 4; ++j) {
			//TODO RENDERING
			RenderUtil.drawSprite(new Point(1 + j * 16, 1), sprite);
		}
		GL11.glDisable(GL11.GL_SCISSOR_TEST);
		CraftGUI.RENDER.texture(ControlLumbermillProgress.SAW, new Point(sawX, -8 + Math.round(6 * (float) Math.sin(this.animation))));
		CraftGUI.RENDER.texture(ControlLumbermillProgress.SAW_2, new Point(sawX + 2, -8 + Math.round(6 * (float) Math.sin(this.animation))));
	}

	@SideOnly(Side.CLIENT)
	private TextureAtlasSprite getWoodSprite(ItemStack stack){
		Minecraft mc = Minecraft.func_71410_x();
		RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
		ItemModelMesher modelMesher = renderItem.func_175037_a();
		IBakedModel model = modelMesher.func_178089_a(stack);
		TextureAtlasSprite sprite = model.func_177554_e();
		if(sprite == mc.func_147117_R().func_174944_f()){
			return getWoodSprite(new ItemStack(Blocks.field_150364_r));
		}
		return sprite;
	}
}
