package binnie.extratrees.genetics;

import java.util.Locale;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import binnie.Constants;

public enum FruitSprite {
	TINY,
	SMALL,
	AVERAGE,
	LARGE,
	LARGER,
	PEAR;

	public static final FruitSprite[] VALUES = values();
	private final ResourceLocation location;

	FruitSprite() {
		location = new ResourceLocation(Constants.EXTRA_TREES_MOD_ID, "blocks/fruit/" + name().toLowerCase(Locale.ENGLISH));
	}

	public ResourceLocation getLocation() {
		return location;
	}

	@SideOnly(Side.CLIENT)
	public void registerSprites() {
		TextureMap map = Minecraft.func_71410_x().func_147117_R();
		map.func_174942_a(location);
	}
}
