package binnie.extratrees.block.decor;

import java.util.ArrayList;
import java.util.List;

import binnie.Constants;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

import net.minecraftforge.common.ForgeHooks;

import binnie.extratrees.block.IPlankType;
import binnie.extratrees.block.WoodManager;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MultiFenceRecipeSize extends IForgeRegistryEntry.Impl<IRecipe> implements IRecipe {
	private ItemStack cached = ItemStack.field_190927_a;

	public MultiFenceRecipeSize() {
		setRegistryName(new ResourceLocation(Constants.EXTRA_TREES_MOD_ID, "multi_fence_size"));
	}

	@Override
	public boolean func_77569_a(final InventoryCrafting inv, final World world) {
		if(inv.func_70302_i_()!=9) return false;
		StringBuilder recipePattern = new StringBuilder();
		List<IPlankType> types = new ArrayList<>();
		for (int i = 0; i < inv.func_70302_i_(); ++i) {
			ItemStack stack = inv.func_70301_a(i);
			boolean isEmpty = stack.func_190926_b();
			IPlankType type;
			if (isEmpty) {
				type = null;
			} else {
				type = WoodManager.getPlankType(stack);
			}
			if (!isEmpty && type == null) {
				return false;
			}
			if (isEmpty) {
				recipePattern.append(" ");
			} else {
				if (!types.contains(type)) {
					types.add(type);
					if (types.size() > 2) {
						return false;
					}
				}
				recipePattern.append(types.indexOf(type));
			}
		}
		if (types.isEmpty()) {
			return false;
		}
		for (MultiFenceRecipePattern pattern : MultiFenceRecipePattern.VALUES) {
			if (pattern.matches(recipePattern.toString()) && types.size()>0 && pattern.getTypeCount()<=types.size()) {
				cached = pattern.createFence(types.get(0), types.get(pattern.getTypeCount() - 1));
				return true;
			}
		}
		this.cached = ItemStack.field_190927_a;
		return false;
	}

	@Override
	public ItemStack func_77572_b(final InventoryCrafting inv) {
		return this.func_77571_b();
	}

	@Override
	public boolean func_194133_a(int width, int height) {
		return width >= 3 && height >= 3;
	}

	@Override
	public ItemStack func_77571_b() {
		return (this.cached.func_190926_b()) ? new ItemStack(Blocks.field_180407_aO) : this.cached;
	}

	@Override
	public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
		return ForgeHooks.defaultRecipeGetRemainingItems(inv);
	}
}
