package binnie.extratrees.block;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.items.ItemBlockLeaves;
import forestry.core.items.IColoredItem;
import forestry.core.items.ItemBlockForestry;
import forestry.core.utils.Translator;

import binnie.extratrees.genetics.ETTreeDefinition;

public class ItemBlockETDecorativeLeaves extends ItemBlockForestry<BlockETDecorativeLeaves> implements IColoredItem {
	public ItemBlockETDecorativeLeaves(Block block) {
		super(block);
	}

	@Override
	public String func_77653_i(ItemStack itemStack) {
		int meta = itemStack.func_77960_j();
		BlockETDecorativeLeaves block = func_179223_d();
		ETTreeDefinition treeDefinition = block.getTreeType(meta);
		if (treeDefinition == null || treeDefinition.getGenome() == null) {
			return Translator.translateToLocal("trees.grammar.leaves.type");
		}

		String unlocalizedSpeciesName = treeDefinition.getGenome().getPrimary().getUnlocalizedName();
		return ItemBlockLeaves.getDisplayName(unlocalizedSpeciesName);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public int getColorFromItemstack(ItemStack itemStack, int renderPass) {
		int meta = itemStack.func_77960_j();
		BlockETDecorativeLeaves block = func_179223_d();
		ETTreeDefinition treeDefinition = block.getTreeType(meta);
		if (treeDefinition == null) {
			return PluginArboriculture.proxy.getFoliageColorBasic();
		}

		ITreeGenome genome = treeDefinition.getGenome();

		if (renderPass == 0) {
			return genome.getPrimary().getLeafSpriteProvider().getColor(false);
		} else {
			IFruitProvider fruitProvider = genome.getFruitProvider();
			return fruitProvider.getDecorativeColor();
		}
	}
}
