package binnie.core.item;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IModelManager;

import binnie.Constants;
import binnie.core.BinnieCore;
import binnie.core.gui.BinnieCoreGUI;

public class ItemFieldKit extends ItemCore {
	private ModelResourceLocation fieldKit;
	private ModelResourceLocation fieldKit1;
	private ModelResourceLocation fieldKit2;
	private ModelResourceLocation fieldKit3;

	public ItemFieldKit() {
		super("field_kit");
		this.func_77655_b("field_kit");
		this.func_77637_a(CreativeTabs.field_78040_i);
		this.func_77625_d(1);
		this.func_77656_e(64);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		manager.registerItemModel(item, new FieldKitMeshDefinition());
		fieldKit = new ModelResourceLocation(Constants.CORE_MOD_ID + ":field_kit", "inventory");
		fieldKit1 = new ModelResourceLocation(Constants.CORE_MOD_ID + ":field_kit1", "inventory");
		fieldKit2 = new ModelResourceLocation(Constants.CORE_MOD_ID + ":field_kit2", "inventory");
		fieldKit3 = new ModelResourceLocation(Constants.CORE_MOD_ID + ":field_kit3", "inventory");
		ModelBakery.registerItemVariants(item, fieldKit, fieldKit1, fieldKit2, fieldKit3);
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
		if (!playerIn.func_70093_af() && handIn == EnumHand.MAIN_HAND) {
			BinnieCore.getBinnieProxy().openGui(BinnieCoreGUI.FIELD_KIT, playerIn, playerIn.func_180425_c());
		}
		return super.func_77659_a(worldIn, playerIn, handIn);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
		final int i = stack.func_77958_k() - stack.func_77952_i();
		if (i == 0) {
			tooltip.add("No paper");
		} else {
			tooltip.add("" + i + " sheet" + ((i > 1) ? "s" : "") + " of paper");
		}
		super.func_77624_a(stack, worldIn, tooltip, flagIn);
	}

	@Override
	public String func_77653_i(final ItemStack p_77653_1_) {
		return "Field Kit";
	}

	@SideOnly(Side.CLIENT)
	private class FieldKitMeshDefinition implements ItemMeshDefinition {
		@Override
		public ModelResourceLocation func_178113_a(ItemStack stack) {
			final int damage = stack.func_77952_i();
			if (damage < 24) {
				return fieldKit3;
			}
			if (damage < 48) {
				return fieldKit2;
			}
			if (damage < 64) {
				return fieldKit1;
			}
			return fieldKit;
		}
	}
}
