package binnie.core.gui.minecraft.control;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.CustomSlot;
import binnie.core.gui.minecraft.GuiCraftGUI;
import binnie.core.gui.minecraft.InventoryType;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.WindowInventory;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.SlotValidator;

public class ControlSlot extends ControlSlotBase {
	public static final Map<EnumHighlighting, List<Integer>> highlighting = new EnumMap<>(EnumHighlighting.class);
	public static boolean shiftClickActive = false;

	static {
		for (final EnumHighlighting h : EnumHighlighting.values()) {
			ControlSlot.highlighting.put(h, new ArrayList<>());
		}
	}

	public final Slot slot;

	public ControlSlot(final IWidget parent, final int x, final int y, final Slot slot) {
		super(parent, x, y);
		this.slot = slot;
		this.addSelfEventHandler(EventMouse.Down.class, event -> {
			Window superParent = (Window) ControlSlot.this.getTopParent();
			GuiCraftGUI superParentGui = superParent.getGui();
			Minecraft mc = superParentGui.getMinecraft();
			final PlayerControllerMP playerController = mc.field_71442_b;
			final int windowId = superParent.getContainer().field_75152_c;
			final int slotNumber = ControlSlot.this.slot.field_75222_d;
			final int button = event.getButton();
			Window.get(ControlSlot.this.getWidget()).getGui();
			if (playerController != null) {
				boolean clone = mc.field_71474_y.field_74322_I.isActiveAndMatches(button  - 100);
				playerController.func_187098_a(windowId, slotNumber, button, clone ? ClickType.CLONE : GuiScreen.func_146272_n() ? ClickType.QUICK_MOVE : ClickType.PICKUP, mc.field_71439_g);
			}
		});
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void onRenderBackground(int guiWidth, int guiHeight) {
		CraftGUI.RENDER.texture(CraftGUITexture.SLOT, Point.ZERO);
		final InventorySlot islot = this.getInventorySlot();
		if (islot != null) {
			SlotValidator validator = islot.getValidator();
			if (validator != null) {
				final TextureAtlasSprite icon = validator.getIcon(!islot.getInputSides().isEmpty());
				if (icon != null && icon != Minecraft.func_71410_x().func_147117_R().func_174944_f()) {
					GlStateManager.func_179147_l();
					RenderUtil.drawSprite(new Point(1, 1), icon);
					GlStateManager.func_179084_k();
				}
			}
		}
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void onRenderForeground(int guiWidth, int guiHeight) {
		boolean highlighted = false;
		for (final Map.Entry<EnumHighlighting, List<Integer>> highlight : ControlSlot.highlighting.entrySet()) {
			if (highlight.getKey() == EnumHighlighting.SHIFT_CLICK && !ControlSlot.shiftClickActive) {
				continue;
			}
			if (highlighted || !highlight.getValue().contains(this.slot.field_75222_d)) {
				continue;
			}
			highlighted = true;
			final int c = -1442840576 + Math.min(highlight.getKey().getColour(), 16777215);
			GlStateManager.func_179084_k();
			GlStateManager.func_179097_i();
			RenderUtil.drawGradientRect(new Area(1, 1, 16, 16), c, c);
			GlStateManager.func_179147_l();
			GlStateManager.func_179126_j();
		}
		if (!highlighted && this.getTopParent().getMousedOverWidget() == this) {
			GuiCraftGUI gui = Window.get(this).getGui();
			GlStateManager.func_179084_k();
			GlStateManager.func_179097_i();
			if (!gui.getDraggedItem().func_190926_b() && !this.slot.func_75214_a(gui.getDraggedItem())) {
				RenderUtil.drawGradientRect(new Area(1, 1, 16, 16), -1426089575, -1426089575);
			} else {
				RenderUtil.drawGradientRect(new Area(1, 1, 16, 16), -2130706433, -2130706433);
			}
			GlStateManager.func_179147_l();
			GlStateManager.func_179126_j();
		}
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void onRenderOverlay() {
		boolean highlighted = false;
		for (final Map.Entry<EnumHighlighting, List<Integer>> highlight : ControlSlot.highlighting.entrySet()) {
			if (highlight.getKey() == EnumHighlighting.SHIFT_CLICK && !ControlSlot.shiftClickActive) {
				continue;
			}
			if (highlighted || !highlight.getValue().contains(this.slot.field_75222_d)) {
				continue;
			}
			highlighted = true;
			final int c = highlight.getKey().getColour();
			Area area = this.getArea();
			if (this.getParent() instanceof ControlSlotArray || this.getParent() instanceof ControlPlayerInventory) {
				area = this.getParent().getArea();
				area.setPosition(Point.ZERO.sub(this.getPosition()));
			}
			RenderUtil.setColour(c);
			CraftGUI.RENDER.texture(CraftGUITexture.OUTLINE, area.outset(1));
		}
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void onUpdateClient() {
		super.onUpdateClient();
		if (this.isMouseOver() && GuiScreen.func_146272_n()) {
			Window.get(this).getContainer().setMouseOverSlot(this.slot);
			ControlSlot.shiftClickActive = true;
		}
		if (Window.get(this).getGui().isHelpMode() && this.isMouseOver()) {
			for (final ControlSlot slot2 : this.getControlSlots()) {
				ControlSlot.highlighting.get(EnumHighlighting.HELP).add(slot2.slot.field_75222_d);
			}
		}
	}

	private List<ControlSlot> getControlSlots() {
		final List<ControlSlot> slots = new ArrayList<>();
		if (this.getParent() instanceof ControlSlotArray || this.getParent() instanceof ControlPlayerInventory) {
			for (final IWidget child : this.getParent().getChildren()) {
				slots.add((ControlSlot) child);
			}
		} else {
			slots.add(this);
		}
		return slots;
	}

	@Override
	public ItemStack getItemStack() {
		return this.slot.func_75211_c();
	}

	@Override
	public void getHelpTooltip(final Tooltip tooltip) {
		final InventorySlot slot = this.getInventorySlot();
		if (slot != null) {
			tooltip.add(slot.getName());
			tooltip.add("Insert Side: " + MachineSide.asString(slot.getInputSides()));
			tooltip.add("Extract Side: " + MachineSide.asString(slot.getOutputSides()));
			if (slot.isReadOnly()) {
				tooltip.add("Pickup Only Slot");
			}
			tooltip.add("Accepts: " + ((slot.getValidator() == null) ? "Any Item" : slot.getValidator().getTooltip()));
		} else if (this.slot.field_75224_c instanceof WindowInventory) {
			final SlotValidator s = ((WindowInventory) this.slot.field_75224_c).getValidator(this.slot.getSlotIndex());
			tooltip.add("Accepts: " + ((s == null) ? "Any Item" : s.getTooltip()));
		} else if (this.slot.field_75224_c instanceof InventoryPlayer) {
			tooltip.add("Player Inventory");
		}
	}

	@Nullable
	public InventorySlot getInventorySlot() {
		if (this.slot instanceof CustomSlot) {
			CustomSlot customSlot = (CustomSlot) this.slot;
			return customSlot.getInventorySlot();
		} else {
			return null;
		}
	}

	public static class Builder {
		private final IWidget parent;
		private final int x;
		private final int y;

		public Builder(final IWidget parent, final int x, final int y) {
			this.parent = parent;
			this.x = x;
			this.y = y;
		}

		public ControlSlot assign(final int index) {
			return assign(InventoryType.MACHINE, index);
		}

		public ControlSlot assign(final InventoryType inventory, final int index) {
			Slot slot = ((Window) parent.getTopParent()).getContainer().createClientSlot(inventory, index);
			return new ControlSlot(parent, x, y, slot);
		}
	}
}
