/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.init;

import binnie.core.util.RecipeUtil;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.alveary.EnumAlvearyLogicType;
import binnie.extrabees.circuit.AlvearySimulatorCircuitType;
import binnie.extrabees.circuit.BinnieCircuitLayout;
import binnie.extrabees.circuit.BinnieCircuitSocketType;
import binnie.extrabees.items.types.EnumHiveFrame;
import binnie.extrabees.items.types.EnumHoneyComb;
import binnie.extrabees.items.types.EnumHoneyDrop;
import binnie.extrabees.items.types.EnumPropolis;
import binnie.extrabees.items.types.ExtraBeeItems;
import binnie.extrabees.utils.Utils;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.core.PluginCore;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemElectronTube;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public final class RecipeRegister {
    private static final RecipeUtil RECIPE_UTIL = new RecipeUtil("extrabees");

    public static void postInitRecipes() {
        if (Loader.isModLoaded((String)"ic2")) {
            RECIPE_UTIL.addRecipe("honey_crystal", ExtraBees.honeyCrystal.getCharged(0.0), "#@#", "@#@", "#@#", Character.valueOf('@'), PluginApiculture.getItems().honeyDrop, Character.valueOf('#'), EnumHoneyDrop.ENERGY.get(1));
        }
        for (EnumHoneyComb enumHoneyComb : EnumHoneyComb.values()) {
            enumHoneyComb.addRecipe();
        }
        for (Enum enum_ : EnumHoneyDrop.values()) {
            ((EnumHoneyDrop)enum_).addRecipe();
        }
        for (Enum enum_ : EnumPropolis.values()) {
            ((EnumPropolis)enum_).addRecipe();
        }
        EnumHiveFrame.init(RECIPE_UTIL);
        RecipeRegister.addForestryRecipes();
        RecipeRegister.addForestryRecipes();
        RecipeRegister.addMiscItemRecipes();
        RecipeRegister.addAlvearyRecipes();
    }

    private static void addAlvearyRecipes() {
        ItemStack alveary = PluginApiculture.getBlocks().getAlvearyBlock(BlockAlvearyType.PLAIN);
        ItemElectronTube thermionicTubes = PluginCore.getItems().tubes;
        ItemCircuitBoard chipsets = PluginCore.getItems().circuitboards;
        RECIPE_UTIL.addRecipe("alveary_mutator", RecipeRegister.getAlvearyPart(EnumAlvearyLogicType.MUTATOR), "g g", " a ", "t t", Character.valueOf('g'), Items.field_151043_k, Character.valueOf('a'), alveary, Character.valueOf('t'), new ItemStack((Item)thermionicTubes, 1, 5));
        RECIPE_UTIL.addRecipe("alveary_frame", RecipeRegister.getAlvearyPart(EnumAlvearyLogicType.FRAME), "iii", "tat", " t ", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('a'), alveary, Character.valueOf('t'), new ItemStack((Item)thermionicTubes, 1, 4));
        RECIPE_UTIL.addRecipe("alveary_rain_shield", RecipeRegister.getAlvearyPart(EnumAlvearyLogicType.RAINSHIELD), " b ", "bab", "t t", Character.valueOf('b'), Items.field_151118_aC, Character.valueOf('a'), alveary, Character.valueOf('t'), new ItemStack((Item)thermionicTubes, 1, 4));
        RECIPE_UTIL.addRecipe("alveary_lighting", RecipeRegister.getAlvearyPart(EnumAlvearyLogicType.LIGHTING), "iii", "iai", " t ", Character.valueOf('i'), Items.field_151114_aO, Character.valueOf('a'), alveary, Character.valueOf('t'), new ItemStack((Item)thermionicTubes, 1, 4));
        RECIPE_UTIL.addRecipe("alveary_stimulator", RecipeRegister.getAlvearyPart(EnumAlvearyLogicType.STIMULATOR), "kik", "iai", " t ", Character.valueOf('i'), Items.field_151074_bl, Character.valueOf('a'), alveary, Character.valueOf('t'), new ItemStack((Item)thermionicTubes, 1, 4), Character.valueOf('k'), new ItemStack((Item)chipsets, 1, 2));
        RECIPE_UTIL.addRecipe("alveary_hatchery", RecipeRegister.getAlvearyPart(EnumAlvearyLogicType.HATCHERY), "i i", " a ", "iti", Character.valueOf('i'), Blocks.field_150410_aZ, Character.valueOf('a'), alveary, Character.valueOf('t'), new ItemStack((Item)thermionicTubes, 1, 5));
        RECIPE_UTIL.addRecipe("alveary_transmission", RecipeRegister.getAlvearyPart(EnumAlvearyLogicType.TRANSMISSION), " t ", "tat", " t ", Character.valueOf('a'), alveary, Character.valueOf('t'), "gearTin");
        BinnieCircuitLayout stimulatorLayout = new BinnieCircuitLayout("Stimulator", BinnieCircuitSocketType.STIMULATOR);
        for (AlvearySimulatorCircuitType type : AlvearySimulatorCircuitType.values()) {
            type.createCircuit(stimulatorLayout);
        }
    }

    private static ItemStack getAlvearyPart(EnumAlvearyLogicType type) {
        return new ItemStack(ExtraBees.alveary, 1, type.ordinal());
    }

    private static void addForestryRecipes() {
        RecipeManagers.carpenterManager.addRecipe(100, Utils.getFluidFromName("water", 2000), ItemStack.field_190927_a, new ItemStack(ExtraBees.dictionary), new Object[]{"X#X", "YEY", "RDR", Character.valueOf('#'), Blocks.field_150410_aZ, Character.valueOf('X'), Items.field_151043_k, Character.valueOf('Y'), "ingotTin", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('E'), Items.field_151166_bC});
    }

    private static void addMiscItemRecipes() {
        ItemStack lapisShard = ExtraBeeItems.LapisShard.get(1);
        RECIPE_UTIL.addShapelessRecipe("lapis_from_shards", new ItemStack(Items.field_151100_aR, 1, 4), lapisShard, lapisShard, lapisShard, lapisShard);
        for (ExtraBeeItems item : ExtraBeeItems.values()) {
            if (item.metalString != null) {
                ItemStack dust = null;
                ItemStack ingot = null;
                if (!OreDictionary.getOres((String)("ingot" + item.metalString)).isEmpty()) {
                    ingot = ((ItemStack)OreDictionary.getOres((String)("ingot" + item.metalString)).get(0)).func_77946_l();
                }
                if (!OreDictionary.getOres((String)("dust" + item.metalString)).isEmpty()) {
                    dust = ((ItemStack)OreDictionary.getOres((String)("dust" + item.metalString)).get(0)).func_77946_l();
                }
                ItemStack input = item.get(1);
                if (dust != null) {
                    RECIPE_UTIL.addShapelessRecipe(item.getModelPath() + "_dust", dust, input, input, input, input);
                    continue;
                }
                if (ingot != null) {
                    RECIPE_UTIL.addShapelessRecipe(item.getModelPath() + "_ingot", ingot, input, input, input, input, input, input, input, input, input);
                    continue;
                }
                if (item != ExtraBeeItems.CoalDust) continue;
                RECIPE_UTIL.addShapelessRecipe("coal_dust_to_coal", new ItemStack(Items.field_151044_h), input, input, input, input);
                continue;
            }
            if (item.gemString == null) continue;
            ItemStack gem = null;
            if (!OreDictionary.getOres((String)("gem" + item.gemString)).isEmpty()) {
                gem = (ItemStack)OreDictionary.getOres((String)("gem" + item.gemString)).get(0);
            }
            ItemStack input2 = item.get(1);
            if (gem == null) continue;
            RECIPE_UTIL.addShapelessRecipe(item.getModelPath() + "_gem", gem.func_77946_l(), input2, input2, input2, input2, input2, input2, input2, input2, input2);
        }
        Item woodGear = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("buildcraftcore", "gear_wood"));
        ItemStack gear = woodGear != null ? new ItemStack(woodGear, 1) : new ItemStack(Blocks.field_150344_f, 1);
        RecipeManagers.carpenterManager.addRecipe(100, Fluids.FOR_HONEY.getFluid(500), ItemStack.field_190927_a, ExtraBeeItems.ScentedGear.get(1), new Object[]{" j ", "bgb", " p ", Character.valueOf('j'), PluginApiculture.getItems().royalJelly, Character.valueOf('b'), PluginCore.getItems().beeswax, Character.valueOf('p'), PluginApiculture.getItems().pollenCluster, Character.valueOf('g'), gear});
    }
}

