package binnie.extratrees.machines.lumbermill.recipes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

import java.util.Collection;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;

import net.minecraftforge.oredict.OreDictionary;

import binnie.core.util.FakeCraftingWorld;
import binnie.core.util.OreDictionaryUtil;
import binnie.extratrees.api.recipes.ILumbermillManager;
import binnie.extratrees.api.recipes.ILumbermillRecipe;

public class LumbermillRecipeManager implements ILumbermillManager {
	//Map<input log item, Pair<input log, output planks>>
	private static Multimap<Item, ILumbermillRecipe> recipes = ArrayListMultimap.create();

	public static ItemStack getPlankProduct(final ItemStack logStack) {
		if (recipes.isEmpty()) {
			calculateProducts();
		}

		Item logItem = logStack.func_77973_b();
		for (ILumbermillRecipe recipe : recipes.get(logItem)) {
			if (recipe.getInput().func_77969_a(logStack)) {
				return recipe.getOutput().func_77946_l();
			}
		}
		return ItemStack.field_190927_a;
	}

	public static void calculateProducts() {
		InventoryCrafting fakeCraftingInventory = new InventoryCrafting(new FakeCraftingHandler(), 3, 3){};

		NonNullList<ItemStack> logs = OreDictionary.getOres("logWood");
		for (ItemStack logStack : logs) {
			if (logStack.func_77952_i() == OreDictionary.WILDCARD_VALUE) {
				for (int i = 0; i < 16; i++) {
					ItemStack logCopy = logStack.func_77946_l();
					logCopy.func_190920_e(1);
					logCopy.func_77964_b(i);

					fakeCraftingInventory.func_174888_l();
					fakeCraftingInventory.func_70299_a(0, logCopy);
					IRecipe recipe = CraftingManager.func_192413_b(fakeCraftingInventory, FakeCraftingWorld.getInstance());
					if (recipe != null) {
						ItemStack recipeOutput = recipe.func_77572_b(fakeCraftingInventory);
						if (!recipeOutput.func_190926_b()) {
							if (OreDictionaryUtil.hasOreName(recipeOutput, "plankWood")) {
								addLogToPlankRecipe(logCopy.func_77946_l(), recipeOutput.func_77946_l());
							}
						}
					}
				}
			} else {
				fakeCraftingInventory.func_174888_l();
				fakeCraftingInventory.func_70299_a(0, logStack.func_77946_l());

				IRecipe recipe = CraftingManager.func_192413_b(fakeCraftingInventory, FakeCraftingWorld.getInstance());
				if (recipe != null) {
					ItemStack recipeOutput = recipe.func_77572_b(fakeCraftingInventory);
					if (!recipeOutput.func_190926_b()) {
						if (OreDictionaryUtil.hasOreName(recipeOutput, "plankWood")) {
							addLogToPlankRecipe(logStack.func_77946_l(), recipeOutput.func_77946_l());
						}
					}
				}
			}
		}
	}

	private static void addLogToPlankRecipe(ItemStack logStack, ItemStack plankStack){
		Item logItem = logStack.func_77973_b();
		plankStack.func_190920_e((int) Math.ceil(plankStack.func_190916_E() * 1.5f)); // turns stack of 4 up to 6
		recipes.put(logItem, new LumbermillRecipe(logStack, plankStack));
	}

	@Override
	public void addRecipe(ItemStack input, ItemStack output) {
		Item logItem = input.func_77973_b();
		recipes.put(logItem, new LumbermillRecipe(input, output));
	}

	@Override
	public boolean addRecipe(ILumbermillRecipe recipe) {
		Item item = recipe.getInput().func_77973_b();
		return recipes.put(item, recipe);
	}

	@Override
	public boolean removeRecipe(ILumbermillRecipe recipe) {
		Item item = recipe.getInput().func_77973_b();
		return recipes.get(item).remove(recipe);
	}

	@Override
	public Collection<ILumbermillRecipe> recipes() {
		return recipes.values();
	}

	private static class FakeCraftingHandler extends Container {
		@Override
		public void func_75130_a(IInventory inventoryIn) {
		}

		@Override
		public boolean func_75145_c(EntityPlayer playerIn) {
			return false;
		}
	}
}
