package binnie.extrabees.items;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

import net.minecraftforge.client.model.ModelLoader;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import binnie.extrabees.alveary.BlockAlveary;
import binnie.extrabees.alveary.EnumAlvearyLogicType;

public class ItemBlockAlveary extends ItemBlock implements IItemModelProvider {
	public ItemBlockAlveary(Block block) {
		super(block);
		setRegistryName(block.getRegistryName());
		func_77627_a(true);
	}
	
	@Override
	public int func_77647_b(int damage) {
		return damage;
	}
	
	@Override
	public String func_77667_c(ItemStack stack) {
		return ((BlockAlveary) field_150939_a).getUnlocalizedName(stack.func_77960_j());
	}
	
	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item) {
		int i = 0;
		for(EnumAlvearyLogicType type : EnumAlvearyLogicType.values()){
			ModelLoader.setCustomModelResourceLocation(item, i, new ModelResourceLocation("extrabees:alveary", "type=" + type.func_176610_l()));
			i++;
		}
	}
}
