package binnie.extrabees.items;

import javax.annotation.Nonnull;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

import net.minecraftforge.client.model.ModelLoader;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import binnie.extrabees.blocks.type.EnumHiveType;

public class ItemBeehive extends ItemBlock implements IItemModelProvider {

	@SuppressWarnings("all")
	public ItemBeehive(@Nonnull final Block block) {
		super(block);
		setRegistryName(block.getRegistryName());
		this.func_77656_e(0);
		this.func_77627_a(true);
		this.func_77637_a(CreativeTabs.field_78030_b);
	}

	@Override
	public int func_77647_b(final int i) {
		return i;
	}

	@Override
	public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
		if (this.func_194125_a(tab)) {
			for (int i = 0; i < EnumHiveType.values().length; ++i) {
				items.add(new ItemStack(this, 1, i));
			}
		}
	}

	@Override
	public String func_77653_i(final ItemStack itemStack) {
		return EnumHiveType.values()[itemStack.func_77952_i()].toString() + " Hive";
	}
	
	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item) {
		int i = 0;
		for(EnumHiveType type : EnumHiveType.values()){
			ModelLoader.setCustomModelResourceLocation(item, i, new ModelResourceLocation("extrabees:hive", "type=" + type.func_176610_l()));
			i++;
		}
	}
}
