package binnie.extrabees.alveary;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Collection;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import net.minecraftforge.common.capabilities.Capability;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.core.multiblock.MultiblockTileEntityForestry;

public class TileEntityExtraBeesAlvearyPart extends MultiblockTileEntityForestry<MultiblockLogicAlveary> implements
	IAlvearyComponent.Active,
	IAlvearyComponent.BeeModifier,
	IAlvearyComponent.BeeListener {

	private String unlocalizedTitle;
	private EnumAlvearyLogicType type;
	private AbstractAlvearyLogic alvearyLogic;

	public TileEntityExtraBeesAlvearyPart() {
		this(null);
	}

	protected TileEntityExtraBeesAlvearyPart(EnumAlvearyLogicType type) {
		super(new MultiblockLogicAlveary());
		if (type != null) {
			this.type = type;
			initFromType();
		}
	}

	private void initFromType() {
		if (alvearyLogic == null) {
			this.unlocalizedTitle = "tile.for.alveary." + type.func_176610_l() + ".name";
			this.alvearyLogic = type.createLogic(this);
		}
	}

	public boolean hasGui() {
		return alvearyLogic.hasGui();
	}

	@Override
	public void func_145839_a(NBTTagCompound data) {
		type = EnumAlvearyLogicType.VALUES[data.func_74771_c("avType")];
		initFromType();
		super.func_145839_a(data);
	}

	@Override
	@Nonnull
	public NBTTagCompound func_189515_b(NBTTagCompound data) {
		data.func_74774_a("avType", (byte) type.ordinal());
		return super.func_189515_b(data);
	}

	@Override
	public void onMachineAssembled(@Nonnull IMultiblockController multiblockController, @Nonnull BlockPos minCoord, @Nonnull BlockPos maxCoord) {
		// Re-render this block on the client
		if (field_145850_b.field_72995_K) {
			this.field_145850_b.func_175704_b(func_174877_v(), func_174877_v());
		}
		field_145850_b.func_175685_c(func_174877_v(), func_145838_q(), false);
	}

	@Override
	public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
		return oldState.func_177230_c() != newState.func_177230_c();
	}

	@Override
	public void onMachineBroken() {
		// Re-render this block on the client
		if (field_145850_b.field_72995_K) {
			this.field_145850_b.func_175704_b(func_174877_v(), func_174877_v());
		}
		field_145850_b.func_175685_c(func_174877_v(), func_145838_q(), false);
		func_70296_d();
	}

	@Nullable
	@Override
	@SideOnly(Side.CLIENT)
	public GuiContainer getGui(@Nonnull EntityPlayer player, int data) {
		return alvearyLogic.getGui(player, data);
	}

	@Nullable
	@Override
	public Container getContainer(@Nonnull EntityPlayer player, int data) {
		return alvearyLogic.getContainer(player, data);
	}

	@Override
	public void updateServer(int tickCount) {
		alvearyLogic.updateServer(this);
	}

	@Override
	public void updateClient(int tickCount) {
		alvearyLogic.updateClient(this);
	}

	@Override
	@Nonnull
	public IBeeListener getBeeListener() {
		return alvearyLogic;
	}

	@Override
	@Nonnull
	public IBeeModifier getBeeModifier() {
		return alvearyLogic;
	}

	@Override
	public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
		return alvearyLogic.hasCapability(capability, facing) || super.hasCapability(capability, facing);
	}

	@Nullable
	@Override
	public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
		return alvearyLogic.hasCapability(capability, facing) ? alvearyLogic.getCapability(capability, facing) : super.getCapability(capability, facing);
	}

	public Collection<IMultiblockComponent> getConnectedComponents() {
		return getMultiblockLogic().getController().getComponents();
	}
}
