package binnie.extrabees.alveary;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import forestry.api.core.Tabs;
import forestry.apiculture.MaterialBeehive;
import forestry.core.gui.GuiHandler;
import forestry.core.tiles.TileUtil;

@SuppressWarnings("deprecation")
public class BlockAlveary extends Block implements ITileEntityProvider {

	private static final PropertyEnum<EnumAlvearyLogicType> TYPE = PropertyEnum.func_177709_a("type", EnumAlvearyLogicType.class);

	public BlockAlveary() {
		super(new MaterialBeehive(false));
		func_149647_a(Tabs.tabApiculture);
		setRegistryName("alveary");
		func_149711_c(1);
		setHarvestLevel("axe", 0);
		func_149672_a(SoundType.field_185848_a);
	}

	@Override
	public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		TileEntityExtraBeesAlvearyPart tile = TileUtil.getTile(worldIn, pos, TileEntityExtraBeesAlvearyPart.class);
		if (tile != null && tile.hasGui()) {
			GuiHandler.openGui(playerIn, tile);
		}
		return true;
	}

	@Nullable
	@Override
	public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
		return new TileEntityExtraBeesAlvearyPart(getType(meta));
	}

	private EnumAlvearyLogicType getType(int meta) {
		IBlockState state = func_176203_a(meta);
		return state.func_177229_b(TYPE);
	}

	@Override
	public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
		for (int i = 0; i < EnumAlvearyLogicType.VALUES.length; i++) {
			list.add(new ItemStack(this, 1, i));
		}
	}

	@Override
	@Nonnull
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, TYPE);
	}

	@Override
	@Nonnull
	public String func_149739_a() {
		return getUnlocalizedName(0);
	}

	@Nonnull
	public String getUnlocalizedName(int meta) {
		return "extrabees.machine.alveay." + getType(meta).func_176610_l();
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(TYPE).ordinal();
	}

	@Override
	@Nonnull
	public IBlockState func_176203_a(int meta) {
		meta = meta >= 0 && meta < EnumAlvearyLogicType.VALUES.length ? meta : 0;
		return func_176223_P().func_177226_a(TYPE, EnumAlvearyLogicType.VALUES[meta]);
	}
	
	@Override
	public int func_180651_a(IBlockState state) {
		return func_176201_c(state);
	}
}
