package binnie.core.machines.inventory;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

import binnie.core.machines.IMachine;

public class ComponentInventorySlots extends ComponentInventory implements IInventoryMachine, IInventorySlots {
	private Map<Integer, InventorySlot> inventory;

	public ComponentInventorySlots(final IMachine machine) {
		super(machine);
		this.inventory = new LinkedHashMap<>();
	}

	@Override
	public void func_174888_l() {
		for (InventorySlot slot : this.inventory.values()) {
			slot.setContent(ItemStack.field_190927_a);
		}
	}

	@Override
	public void func_174885_b(int id, int value) {

	}

	@Override
	public int func_174887_a_(int id) {
		return 0;
	}

	@Override
	public int func_174890_g() {
		return 0;
	}

	@Override
	public ItemStack func_70304_b(int index) {
		InventorySlot inventorySlot = this.inventory.get(index);
		ItemStack content = inventorySlot.getItemStack();
		inventorySlot.setContent(ItemStack.field_190927_a);
		return content;
	}

	@Override
	public ITextComponent func_145748_c_() {
		return new TextComponentString("");
	}

	@Override
	public int func_70302_i_() {
		int size = 0;
		for (final Integer index : this.inventory.keySet()) {
			size = Math.max(size, index + 1);
		}
		return size;
	}

	@Override
	public ItemStack func_70301_a(final int index) {
		if (this.inventory.containsKey(index)) {
			return this.inventory.get(index).getItemStack();
		}
		return ItemStack.field_190927_a;
	}

	@Override
	public ItemStack func_70298_a(final int index, final int amount) {
		if (this.inventory.containsKey(index)) {
			final ItemStack stack = this.inventory.get(index).decrStackSize(amount);
			this.func_70296_d();
			return stack;
		}
		return ItemStack.field_190927_a;
	}

	@Override
	public void func_70299_a(final int index, final ItemStack itemStack) {
		if (this.inventory.containsKey(index) && (itemStack.func_190926_b() || this.inventory.get(index).isValid(itemStack))) {
			this.inventory.get(index).setContent(itemStack);
		}
		this.func_70296_d();
	}

	@Override
	public boolean func_191420_l() {
		return this.inventory.isEmpty();
	}
	
	@Override
	public String func_70005_c_() {
		return "";
	}
	
	@Override
	public int func_70297_j_() {
		return 64;
	}

	@Override
	public boolean func_70300_a(final EntityPlayer var1) {
		return true;
	}

	@Override
	public void func_174886_c(EntityPlayer player) {

	}

	@Override
	public void func_174889_b(EntityPlayer player) {

	}

	@Override
	public void readFromNBT(final NBTTagCompound nbttagcompound) {
		super.readFromNBT(nbttagcompound);
		if (nbttagcompound.func_74764_b("inventory")) {
			final NBTTagList inventoryNBT = nbttagcompound.func_150295_c("inventory", 10);
			for (int i = 0; i < inventoryNBT.func_74745_c(); ++i) {
				final NBTTagCompound slotNBT = inventoryNBT.func_150305_b(i);
				int index = slotNBT.func_74762_e("id");
				if (slotNBT.func_74764_b("Slot")) {
					index = (slotNBT.func_74771_c("Slot") & 0xFF);
				}
				if (this.inventory.containsKey(index)) {
					this.inventory.get(index).readFromNBT(slotNBT);
				}
			}
		}
		this.func_70296_d();
	}

	@Override
	public NBTTagCompound writeToNBT(final NBTTagCompound nbttagcompound2) {
		NBTTagCompound nbttagcompound = super.writeToNBT(nbttagcompound2);
		final NBTTagList inventoryNBT = new NBTTagList();
		for (final Map.Entry<Integer, InventorySlot> entry : this.inventory.entrySet()) {
			final NBTTagCompound slotNBT = new NBTTagCompound();
			slotNBT.func_74768_a("id", entry.getKey());
			entry.getValue().writeToNBT(slotNBT);
			inventoryNBT.func_74742_a(slotNBT);
		}
		nbttagcompound.func_74782_a("inventory", inventoryNBT);
		return nbttagcompound;
	}

	public final InventorySlot addSlot(final int index, final String unlocName) {
		InventorySlot slot = new InventorySlot(index, unlocName);
		this.inventory.put(index, slot);
		return slot;
	}

	public final InventorySlot[] addSlotArray(final int[] indexes, final String unlocName) {
		for (final int k : indexes) {
			this.addSlot(k, unlocName);
		}
		return this.getSlots(indexes);
	}

	@Override
	@Nullable
	public InventorySlot getSlot(final int index) {
		if (this.inventory.containsKey(index)) {
			return this.inventory.get(index);
		}
		return null;
	}

	public InventorySlot[] getSlots(final int[] indexes) {
		final List<InventorySlot> list = new ArrayList<>();
		for (final int i : indexes) {
			if (this.getSlot(i) != null) {
				list.add(this.getSlot(i));
			}
		}
		return list.toArray(new InventorySlot[0]);
	}

	private boolean isReadOnly(final int slot) {
		final InventorySlot iSlot = this.getSlot(slot);
		return iSlot == null || iSlot.isReadOnly();
	}

	@Override
	public boolean func_145818_k_() {
		return true;
	}

	@Override
	public boolean func_94041_b(final int slot, final ItemStack itemStack) {
		final InventorySlot iSlot = this.getSlot(slot);
		return iSlot != null && (iSlot.isValid(itemStack) && !this.isReadOnly(slot));
	}

	@Override
	public void onDestruction() {
		for (final InventorySlot slot : this.inventory.values()) {
			final ItemStack stack = slot.getItemStack();
			if (!slot.isRecipe() && !stack.func_190926_b()) {
				final float f = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
				final float f2 = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
				final float f3 = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
				if (stack.func_190916_E() == 0) {
					stack.func_190920_e(1);
				}
				final EntityItem entityitem = new EntityItem(this.getMachine().getWorld(), this.getMachine().getTileEntity().func_174877_v().func_177958_n() + f, this.getMachine().getTileEntity().func_174877_v().func_177956_o() + f2, this.getMachine().getTileEntity().func_174877_v().func_177952_p() + f3, stack.func_77946_l());
				final float accel = 0.05f;
				entityitem.field_70159_w = (float) this.getMachine().getWorld().field_73012_v.nextGaussian() * accel;
				entityitem.field_70181_x = (float) this.getMachine().getWorld().field_73012_v.nextGaussian() * accel + 0.2f;
				entityitem.field_70179_y = (float) this.getMachine().getWorld().field_73012_v.nextGaussian() * accel;
				this.getMachine().getWorld().func_72838_d(entityitem);
			}
		}
	}

	@Override
	public int[] func_180463_a(final EnumFacing facing) {
		final List<Integer> slots = new ArrayList<>();
		for (final InventorySlot slot : this.inventory.values()) {
			if (slot.canInsert() || slot.canExtract()) {
				slots.add(slot.getIndex());
			}
		}
		final int[] ids = new int[slots.size()];
		for (int i = 0; i < slots.size(); ++i) {
			ids[i] = slots.get(i);
		}
		return ids;
	}

	@Override
	public boolean func_180462_a(final int index, final ItemStack itemstack, final EnumFacing direction) {
		if (this.func_94041_b(index, itemstack)) {
			InventorySlot slot = this.getSlot(index);
			if (slot != null && slot.canInsert(direction)) {
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean func_180461_b(final int index, final ItemStack itemstack, final EnumFacing direction) {
		InventorySlot slot = this.getSlot(index);
		return slot != null && slot.canExtract(direction);
	}
}
