package binnie.botany.modules;

import com.google.common.collect.ImmutableSet;

import java.util.Set;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

import forestry.api.recipes.RecipeManagers;

import binnie.Binnie;
import binnie.Constants;
import binnie.botany.Botany;
import binnie.botany.items.ItemDatabaseBotany;
import binnie.core.liquid.ManagerLiquid;
import binnie.modules.BinnieModule;
import binnie.modules.Module;

@BinnieModule(moduleID = BotanyModuleUIDs.DATABASE, moduleContainerID = Constants.BOTANY_MOD_ID, name = "Database", unlocalizedDescription = "botany.module.database")
public class ModuleDatabase extends Module {
	public static ItemDatabaseBotany database;

	@Override
	public void registerItemsAndBlocks() {
		database = new ItemDatabaseBotany();
		Botany.proxy.registerItem(database);
	}

	@Override
	public void postInit() {
		RecipeManagers.carpenterManager.addRecipe(
			100,
			Binnie.LIQUID.getFluidStack(ManagerLiquid.WATER, 2000),
			ItemStack.field_190927_a,
			new ItemStack(database),
			"X#X",
			"YEY",
			"RDR",
			'#', Blocks.field_150410_aZ,
			'X', Items.field_151043_k,
			'Y', Items.field_151074_bl,
			'R', Items.field_151137_ax,
			'D', Items.field_151045_i,
			'E', Items.field_151166_bC
		);
	}

	@Override
	public Set<String> getDependencyUids() {
		return ImmutableSet.of(BotanyModuleUIDs.FLOWERS);
	}
}
