package binnie.botany.models;

import com.google.common.collect.Maps;

import java.util.Map;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import binnie.Constants;
import binnie.botany.api.genetics.IFlowerType;
import binnie.botany.blocks.BlockFlower;

@SideOnly(Side.CLIENT)
public class StateMapperFlower extends StateMapperBase {
	@Override
	protected ModelResourceLocation func_178132_a(IBlockState state) {
		Map<IProperty<?>, Comparable<?>> properties = Maps.newLinkedHashMap(state.func_177228_b());
		IFlowerType flowerType = (IFlowerType) state.func_177229_b(BlockFlower.FLOWER);
		if (flowerType.getSections() < 2) {
			properties.remove(BlockFlower.SECTION);
		} else if (flowerType.getSections() <= state.func_177229_b(BlockFlower.SECTION)) {
			properties.put(BlockFlower.SECTION, flowerType.getSections() - 1);
		}

		if (state.func_177229_b(BlockFlower.SEED)) {
			properties.remove(BlockFlower.SECTION);
			properties.remove(BlockFlower.FLOWER);
			properties.remove(BlockFlower.FLOWERED);
		} else {
			properties.remove(BlockFlower.SEED);
		}
		return new ModelResourceLocation(Constants.BOTANY_MOD_ID + ":flower", func_178131_a(properties));
	}
}
