/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.integration.jei;

import binnie.core.integration.jei.Drawables;
import binnie.extratrees.alcohol.ModuleAlcohol;
import binnie.extratrees.block.ModuleBlocks;
import binnie.extratrees.block.WoodManager;
import binnie.extratrees.block.decor.FenceDescription;
import binnie.extratrees.block.decor.FenceType;
import binnie.extratrees.integration.jei.brewery.BreweryRecipeCategory;
import binnie.extratrees.integration.jei.brewery.BreweryRecipeMaker;
import binnie.extratrees.integration.jei.distillery.DistilleryRecipeCategory;
import binnie.extratrees.integration.jei.distillery.DistilleryRecipeMaker;
import binnie.extratrees.integration.jei.fruitpress.FruitPressRecipeCategory;
import binnie.extratrees.integration.jei.fruitpress.FruitPressRecipeMaker;
import binnie.extratrees.integration.jei.lumbermill.LumbermillRecipeCategory;
import binnie.extratrees.integration.jei.lumbermill.LumbermillRecipeMaker;
import binnie.extratrees.integration.jei.multifence.MultiFenceRecipeRegistryPlugin;
import binnie.extratrees.machines.ExtraTreeMachine;
import binnie.modules.ModuleManager;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

@JEIPlugin
public class ExtraTreesJeiPlugin
extends BlankModPlugin {
    public static IJeiHelpers jeiHelpers;
    public static IGuiHelper guiHelper;
    public static Drawables drawables;

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        if (ModuleManager.isEnabled("extratrees", "extratrees.wood")) {
            subtypeRegistry.registerSubtypeInterpreter(Item.func_150898_a((Block)ModuleBlocks.blockMultiFence), itemStack -> {
                FenceDescription desc = WoodManager.getFenceDescription(itemStack);
                if (desc != null) {
                    FenceType type = WoodManager.getFenceType(itemStack);
                    return type + ":" + desc.getPlankType().getDesignMaterialName().toLowerCase() + ":" + desc.getSecondaryPlankType().getDesignMaterialName().toLowerCase();
                }
                return Integer.toString(itemStack.func_77952_i());
            });
        }
        if (ModuleManager.isEnabled("extratrees", "extratrees.alcohol")) {
            subtypeRegistry.registerSubtypeInterpreter((Item)ModuleAlcohol.drink, itemStack -> {
                String glassware = ModuleAlcohol.drink.getGlassware(itemStack).getName();
                FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack);
                if (fluidStack == null) {
                    return glassware;
                }
                return glassware + ":" + fluidStack.getFluid().getName();
            });
        }
    }

    public void register(IModRegistry registry) {
        if (ModuleManager.isEnabled("extratrees", "extratrees.machines")) {
            registry.addRecipeCatalyst((Object)ExtraTreeMachine.Lumbermill.get(1), new String[]{"binnie.extratrees.lumbermill"});
            registry.addRecipeCatalyst((Object)ExtraTreeMachine.Press.get(1), new String[]{"binnie.extratrees.fruitpress"});
            registry.addRecipeCatalyst((Object)ExtraTreeMachine.BREWERY.get(1), new String[]{"binnie.extratrees.brewing"});
            registry.addRecipeCatalyst((Object)ExtraTreeMachine.Distillery.get(1), new String[]{"binnie.extratrees.distilling"});
            registry.addRecipes(LumbermillRecipeMaker.create(), "binnie.extratrees.lumbermill");
            registry.addRecipes(FruitPressRecipeMaker.create(), "binnie.extratrees.fruitpress");
            registry.addRecipes(BreweryRecipeMaker.create(), "binnie.extratrees.brewing");
            registry.addRecipes(DistilleryRecipeMaker.create(), "binnie.extratrees.distilling");
        }
        if (ModuleManager.isEnabled("extratrees", "extratrees.wood")) {
            registry.addRecipeRegistryPlugin((IRecipeRegistryPlugin)new MultiFenceRecipeRegistryPlugin());
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        guiHelper = jeiHelpers.getGuiHelper();
        drawables = Drawables.getDrawables(guiHelper);
        if (ModuleManager.isEnabled("extratrees", "extratrees.machines")) {
            registry.addRecipeCategories(new IRecipeCategory[]{new LumbermillRecipeCategory(), new FruitPressRecipeCategory(), new BreweryRecipeCategory(), new DistilleryRecipeCategory()});
        }
    }
}

