/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.network;

import binnie.core.AbstractMod;
import binnie.core.network.IPacketID;
import binnie.core.network.IPacketProvider;
import binnie.core.network.packet.MessageBinnie;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BinniePacketHandler
implements IMessageHandler<MessageBinnie, IMessage> {
    @SidedProxy(modId="binniecore")
    private static MessageProxy messageProxy;
    @Nullable
    private IPacketProvider provider;

    public BinniePacketHandler(AbstractMod mod) {
        this.setProvider(mod);
    }

    private IPacketProvider getProvider() {
        Preconditions.checkState((this.provider != null ? 1 : 0) != 0, (Object)"provider has not been set.");
        return this.provider;
    }

    public void setProvider(IPacketProvider provider) {
        this.provider = provider;
    }

    @Nullable
    public IMessage onMessage(MessageBinnie message, MessageContext ctx) {
        int packetId = message.id;
        for (IPacketID id : this.getProvider().getPacketIDs()) {
            if (id.ordinal() != packetId) continue;
            messageProxy.onMessage(id, message, ctx);
            return null;
        }
        return null;
    }

    public static class ServerProxy
    extends MessageProxy {
        @Override
        public void onMessage(IPacketID id, MessageBinnie message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ServerProxy.checkThreadAndEnqueue(id, message, ctx, (IThreadListener)player.func_71121_q());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientProxy
    extends MessageProxy {
        @Override
        public void onMessage(IPacketID id, MessageBinnie message, MessageContext ctx) {
            ClientProxy.checkThreadAndEnqueue(id, message, ctx, (IThreadListener)Minecraft.func_71410_x());
        }
    }

    private static abstract class MessageProxy {
        private MessageProxy() {
        }

        protected static void checkThreadAndEnqueue(IPacketID id, MessageBinnie message, MessageContext ctx, IThreadListener threadListener) {
            if (!threadListener.func_152345_ab()) {
                threadListener.func_152344_a(() -> id.onMessage(message, ctx));
            }
        }

        public abstract void onMessage(IPacketID var1, MessageBinnie var2, MessageContext var3);
    }
}

