/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics;

import binnie.botany.api.BotanyAPI;
import binnie.botany.api.gardening.EnumAcidity;
import binnie.botany.api.gardening.EnumMoisture;
import binnie.botany.api.genetics.EnumFlowerChromosome;
import binnie.botany.api.genetics.EnumFlowerStage;
import binnie.botany.api.genetics.IAlleleFlowerSpecies;
import binnie.botany.api.genetics.IAlleleFlowerSpeciesBuilder;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerDefinition;
import binnie.botany.api.genetics.IFlowerGenome;
import binnie.botany.api.genetics.IFlowerMutationBuilder;
import binnie.botany.api.genetics.IFlowerRoot;
import binnie.botany.api.genetics.IFlowerType;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.genetics.EnumFlowerType;
import binnie.botany.genetics.Flower;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.AlleleSpeciesRegisterEvent;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleRegistry;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public enum FlowerDefinition implements IFlowerDefinition
{
    Dandelion("Dandelion", "taraxacum", "officinale", (IFlowerType)EnumFlowerType.DANDELION, EnumFlowerColor.Yellow){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTENED);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOWER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Poppy("Poppy", "papaver", "rhoeas", (IFlowerType)EnumFlowerType.POPPY, EnumFlowerColor.Red){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Orchid("Orchid", "vanda", "coerulea", (IFlowerType)EnumFlowerType.ORCHID, EnumFlowerColor.DeepSkyBlue){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ACID);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Allium("Allium", "allium", "giganteum", (IFlowerType)EnumFlowerType.ALLIUM, EnumFlowerColor.MediumPurple){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ALKALINE);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Bluet("Bluet", "houstonia", "caerulea", (IFlowerType)EnumFlowerType.BLUET, EnumFlowerColor.Lavender, EnumFlowerColor.Khaki){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setMoisture(EnumMoisture.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOWER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.OliveDrab.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Tulip("Tulip", "tulipa", "agenensis", (IFlowerType)EnumFlowerType.TULIP, EnumFlowerColor.Violet){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.OliveDrab.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Daisy("Daisy", "leucanthemum", "vulgare", (IFlowerType)EnumFlowerType.DAISY, EnumFlowerColor.White, EnumFlowerColor.Yellow){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.OliveDrab.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Cornflower("Cornflower", "centaurea", "cyanus", (IFlowerType)EnumFlowerType.CORNFLOWER, EnumFlowerColor.SkyBlue){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.OliveDrab.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Dandelion, Tulip, 10);
        }
    }
    ,
    Pansy("Pansy", "viola", "tricolor", (IFlowerType)EnumFlowerType.PANSY, EnumFlowerColor.Pink, EnumFlowerColor.Purple){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ACID);
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTENED);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.SeaGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Tulip, Viola, 5);
        }
    }
    ,
    Iris("Iris", "iris", "germanica", (IFlowerType)EnumFlowerType.IRIS, EnumFlowerColor.LightGray, EnumFlowerColor.Purple){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ACID);
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.SeaGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Orchid, Viola, 10);
        }
    }
    ,
    Lavender("Lavender", "Lavandula", "angustifolia", (IFlowerType)EnumFlowerType.LAVENDER, EnumFlowerColor.MediumOrchid){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Allium, Viola, 10);
        }
    }
    ,
    Viola("Viola", "viola", "odorata", (IFlowerType)EnumFlowerType.VIOLA, EnumFlowerColor.MediumPurple, EnumFlowerColor.SlateBlue){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ACID);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTENED);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.OliveDrab.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Orchid, Poppy, 15);
        }
    }
    ,
    Daffodil("Daffodil", "narcissus", "pseudonarcissus", (IFlowerType)EnumFlowerType.DAFFODIL, EnumFlowerColor.Yellow, EnumFlowerColor.Gold){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.ELONGATED);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Dandelion, Poppy, 10);
        }
    }
    ,
    Dahlia("Dahlia", "dahlia", "variabilis", (IFlowerType)EnumFlowerType.DAHLIA, EnumFlowerColor.HotPink, EnumFlowerColor.DeepPink){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.OliveDrab.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Daisy, Allium, 15);
        }
    }
    ,
    Peony("Peony", "paeonia", "suffruticosa", (IFlowerType)EnumFlowerType.PEONY, EnumFlowerColor.Thistle){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ALKALINE);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.DarkGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Rose("ROSE", "rosa", "rubiginosa", (IFlowerType)EnumFlowerType.ROSE, EnumFlowerColor.Red){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ACID);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Lilac("Lilac", "syringa", "vulgaris", (IFlowerType)EnumFlowerType.LILAC, EnumFlowerColor.Plum){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ALKALINE);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.OliveDrab.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    Hydrangea("Hydrangea", "hydrangea", "macrophylla", (IFlowerType)EnumFlowerType.HYDRANGEA, EnumFlowerColor.DeepSkyBlue){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setMoisture(EnumMoisture.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.DarkGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Peony, Bluet, 10);
        }
    }
    ,
    Foxglove("Foxglove", "digitalis", "purpurea", (IFlowerType)EnumFlowerType.FOXGLOVE, EnumFlowerColor.HotPink){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTENED);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.DarkGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Lilac, Zinnia, 5);
        }
    }
    ,
    Zinnia("Zinnia", "zinnia", "elegans", (IFlowerType)EnumFlowerType.ZINNIA, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Yellow){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.MediumSeaGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            Zinnia.registerMutation(Dahlia, Marigold, 5);
        }
    }
    ,
    Chrysanthemum("Chrysanthemum", "chrysanthemum", "\u00ef?? grandiflorum", (IFlowerType)EnumFlowerType.MUMS, EnumFlowerColor.Violet){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.MediumSeaGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Geranium, Rose, 10);
        }
    }
    ,
    Marigold("Marigold", "calendula", "officinalis", (IFlowerType)EnumFlowerType.MARIGOLD, EnumFlowerColor.Gold, EnumFlowerColor.DarkOrange){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Daisy, Dandelion, 10);
        }
    }
    ,
    Geranium("Geranium", "geranium", "maderense", (IFlowerType)EnumFlowerType.GERANIUM, EnumFlowerColor.DeepPink){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.MediumSeaGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Tulip, Orchid, 15);
        }
    }
    ,
    Azalea("Azalea", "rhododendrons", "aurigeranum", (IFlowerType)EnumFlowerType.AZALEA, EnumFlowerColor.HotPink){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ACID);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Orchid, Geranium, 5);
        }
    }
    ,
    Primrose("Primrose", "primula", "vulgaris", (IFlowerType)EnumFlowerType.PRIMROSE, EnumFlowerColor.Red, EnumFlowerColor.Gold){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ACID);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Chrysanthemum, Auricula, 5);
        }
    }
    ,
    Aster("Aster", "aster", "amellus", (IFlowerType)EnumFlowerType.ASTER, EnumFlowerColor.MediumPurple, EnumFlowerColor.Goldenrod){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.HIGHER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Daisy, Tulip, 10);
        }
    }
    ,
    Carnation("Carnation", "dianthus", "caryophyllus", (IFlowerType)EnumFlowerType.CARNATION, EnumFlowerColor.Crimson, EnumFlowerColor.White){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ALKALINE);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.SeaGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Dianthus, Rose, 5);
        }
    }
    ,
    Lily("Lily", "lilium", "auratum", (IFlowerType)EnumFlowerType.LILY, EnumFlowerColor.Pink, EnumFlowerColor.Gold){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Tulip, Chrysanthemum, 5);
        }
    }
    ,
    Yarrow("Yarrow", "achillea", "millefolium", (IFlowerType)EnumFlowerType.YARROW, EnumFlowerColor.Yellow){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ACID);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.DarkOliveGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Dandelion, Orchid, 10);
        }
    }
    ,
    Petunia("Petunia", "petunia", "\u00ef?? atkinsiana", (IFlowerType)EnumFlowerType.Petunia, EnumFlowerColor.MediumVioletRed, EnumFlowerColor.Thistle){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Tulip, Dahlia, 5);
        }
    }
    ,
    Agapanthus("Agapanthus", "agapanthus", "praecox", (IFlowerType)EnumFlowerType.AGAPANTHUS, EnumFlowerColor.DeepSkyBlue){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.DarkOliveGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Allium, Geranium, 5);
        }
    }
    ,
    Fuchsia("Fuchsia", "fuchsia", "magellanica", (IFlowerType)EnumFlowerType.FUCHSIA, EnumFlowerColor.DeepPink, EnumFlowerColor.MediumOrchid){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTENED);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.SeaGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Foxglove, Dahlia, 5);
        }
    }
    ,
    Dianthus("Dianthus", "dianthus", "barbatus", (IFlowerType)EnumFlowerType.DIANTHUS, EnumFlowerColor.Crimson, EnumFlowerColor.HotPink){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ALKALINE);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.OliveDrab.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Tulip, Poppy, 15);
        }
    }
    ,
    Forget("Forget-me-nots", "myosotis", "arvensis", (IFlowerType)EnumFlowerType.FORGET, EnumFlowerColor.LightSteelBlue){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ACID);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOWER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Orchid, Bluet, 10);
        }
    }
    ,
    Anemone("Anemone", "anemone", "coronaria", (IFlowerType)EnumFlowerType.ANEMONE, EnumFlowerColor.Red, EnumFlowerColor.MistyRose){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.DarkOliveGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            Anemone.registerMutation(Aquilegia, Rose, 5);
        }
    }
    ,
    Aquilegia("Aquilegia", "aquilegia", "vulgaris", (IFlowerType)EnumFlowerType.AQUILEGIA, EnumFlowerColor.SlateBlue, EnumFlowerColor.Thistle){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.MediumSeaGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Iris, Poppy, 5);
        }
    }
    ,
    Edelweiss("Edelweiss", "leontopodium", "alpinum", (IFlowerType)EnumFlowerType.EDELWEISS, EnumFlowerColor.White, EnumFlowerColor.Khaki){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ALKALINE);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOWEST);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.DarkOliveGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            Edelweiss.registerMutation(Peony, Bluet, 5);
        }
    }
    ,
    Scabious("Scabious", "scabiosa", "columbaria", (IFlowerType)EnumFlowerType.SCABIOUS, EnumFlowerColor.RoyalBlue){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTENED);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.OliveDrab.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Allium, Cornflower, 5);
        }
    }
    ,
    Coneflower("Coneflower", "echinacea", "purpurea", (IFlowerType)EnumFlowerType.CONEFLOWER, EnumFlowerColor.Violet, EnumFlowerColor.DarkOrange){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.HIGHER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.DarkOliveGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Tulip, Cornflower, 5);
        }
    }
    ,
    Gaillardia("Gaillardia", "gaillardia", "aristata", (IFlowerType)EnumFlowerType.GAILLARDIA, EnumFlowerColor.DarkOrange, EnumFlowerColor.Yellow){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setMoisture(EnumMoisture.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.HIGHER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.OliveDrab.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Dandelion, Marigold, 5);
        }
    }
    ,
    Auricula("Auricula", "primula", "auricula", (IFlowerType)EnumFlowerType.AURICULA, EnumFlowerColor.Red, EnumFlowerColor.Yellow){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ACID);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.ELONGATED);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.DarkOliveGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Poppy, Geranium, 10);
        }
    }
    ,
    Camellia("Camellia", "camellia", "japonica", (IFlowerType)EnumFlowerType.CAMELLIA, EnumFlowerColor.Crimson){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setPH(EnumAcidity.ACID);
            flowerSpecies.setMoisture(EnumMoisture.DAMP);
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.DarkOliveGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Hydrangea, Rose, 5);
        }
    }
    ,
    Goldenrod("Goldenrod", "solidago", "canadensis", (IFlowerType)EnumFlowerType.GOLDENROD, EnumFlowerColor.Gold){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.HIGHER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.MediumSeaGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Lilac, Marigold, 10);
        }
    }
    ,
    Althea("Althea", "althaea", "officinalis", (IFlowerType)EnumFlowerType.ALTHEA, EnumFlowerColor.Thistle, EnumFlowerColor.MediumOrchid){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.ELONGATED);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.HIGH);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.DarkGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Hydrangea, Iris, 5);
        }
    }
    ,
    Penstemon("Penstemon", "penstemon", "digitalis", (IFlowerType)EnumFlowerType.PENSTEMON, EnumFlowerColor.MediumOrchid, EnumFlowerColor.Thistle){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setMoisture(EnumMoisture.DRY);
            flowerSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.OliveDrab.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Peony, Lilac, 5);
        }
    }
    ,
    Delphinium("Delphinium", "delphinium", "staphisagria", (IFlowerType)EnumFlowerType.DELPHINIUM, EnumFlowerColor.DarkSlateBlue){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
            flowerSpecies.setMoisture(EnumMoisture.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.STEM, (IAllele)EnumFlowerColor.DarkSeaGreen.getFlowerColorAllele());
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Lilac, Bluet, 5);
        }
    }
    ,
    Hollyhock("Hollyhock", "Alcea", "rosea", (IFlowerType)EnumFlowerType.HOLLYHOCK, EnumFlowerColor.Black, EnumFlowerColor.Gold){

        @Override
        protected void setSpeciesProperties(IAlleleFlowerSpeciesBuilder flowerSpecies) {
        }

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.SAPPINESS, (IAlleleValue)EnumAllele.Sappiness.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumFlowerChromosome.PH_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(Delphinium, Lavender, 5);
        }
    };

    public static FlowerDefinition[] VALUES;
    private final IAlleleFlowerSpecies species;
    IFlowerType<EnumFlowerType> type;
    String name;
    String binomial;
    String branchName;
    List<IAllele[]> variantTemplates;
    @Nullable
    IClassification branch;
    EnumFlowerColor primaryColor;
    EnumFlowerColor secondaryColor;
    private IAllele[] template;
    private IFlowerGenome genome;

    private FlowerDefinition(String name, String branch, String binomial, IFlowerType<EnumFlowerType> type, EnumFlowerColor colour) {
        this(name, branch, binomial, type, false, colour, colour);
    }

    private FlowerDefinition(String name, String branch, String binomial, IFlowerType<EnumFlowerType> type, EnumFlowerColor primaryColor, EnumFlowerColor secondaryColor) {
        this(name, branch, binomial, type, true, primaryColor, secondaryColor);
    }

    private FlowerDefinition(String name, String branch, String binomial, IFlowerType<EnumFlowerType> type, boolean isDominant, EnumFlowerColor colour) {
        this(name, branch, binomial, type, isDominant, colour, colour);
    }

    private FlowerDefinition(String name, String branch, String binomial, IFlowerType<EnumFlowerType> flowerType, boolean isDominant, EnumFlowerColor primaryColor, EnumFlowerColor secondaryColor) {
        String uid = "botany.flower" + this;
        String unlocalizedDescription = "botany.description.flower" + this;
        String unlocalizedName = "botany.flowers.species." + name;
        this.variantTemplates = new ArrayList<IAllele[]>();
        this.name = name;
        this.binomial = binomial;
        this.branchName = branch;
        this.type = flowerType;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        IAlleleFlowerSpeciesBuilder speciesBuilder = BotanyAPI.flowerFactory.createSpecies(uid, unlocalizedName, "Binnie's Mod Team", unlocalizedDescription, isDominant, this.getBranch(), binomial, flowerType);
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
        if (this.branch != null) {
            this.branch.addMemberSpecies((IAlleleSpecies)this.species);
        }
    }

    private static void setupVariants() {
        IFlowerRoot flowerRood = BotanyCore.getFlowerRoot();
        flowerRood.addConversion(new ItemStack((Block)Blocks.field_150327_N, 1, 0), Dandelion.getTemplate());
        flowerRood.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 0), Poppy.getTemplate());
        flowerRood.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 1), Orchid.getTemplate());
        flowerRood.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 2), Allium.getTemplate());
        flowerRood.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 3), Bluet.getTemplate());
        flowerRood.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 7), Tulip.getTemplate());
        flowerRood.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 8), Daisy.getTemplate());
        flowerRood.addConversion(new ItemStack((Block)Blocks.field_150398_cm, 1, 1), Lilac.getTemplate());
        flowerRood.addConversion(new ItemStack((Block)Blocks.field_150398_cm, 1, 4), Rose.getTemplate());
        flowerRood.addConversion(new ItemStack((Block)Blocks.field_150398_cm, 1, 5), Peony.getTemplate());
        flowerRood.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 6), Tulip.addVariant(EnumFlowerColor.White));
        flowerRood.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 4), Tulip.addVariant(EnumFlowerColor.Crimson));
        flowerRood.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 5), Tulip.addVariant(EnumFlowerColor.DarkOrange));
    }

    public static void preInitFlowers() {
        MinecraftForge.EVENT_BUS.post((Event)new AlleleSpeciesRegisterEvent((ISpeciesRoot)BotanyAPI.flowerRoot, IAlleleFlowerSpecies.class));
        for (FlowerDefinition def : FlowerDefinition.values()) {
            IFlowerType type = def.species.getType();
            if (EnumFlowerType.highestSection >= type.getSections()) continue;
            EnumFlowerType.highestSection = type.getSections();
        }
    }

    public static void initFlowers() {
        for (FlowerDefinition flower : FlowerDefinition.values()) {
            flower.init();
        }
        FlowerDefinition.setupVariants();
        for (FlowerDefinition flower : FlowerDefinition.values()) {
            flower.registerMutations();
        }
    }

    private static void markAllelesAsValid(IChromosomeType existingType, IChromosomeType newType) {
        IAlleleRegistry alleleRegistry = AlleleManager.alleleRegistry;
        Collection alleles = alleleRegistry.getRegisteredAlleles(existingType);
        for (IAllele allele : alleles) {
            alleleRegistry.addValidAlleleTypes(allele, new IChromosomeType[]{newType});
        }
    }

    protected abstract void setSpeciesProperties(IAlleleFlowerSpeciesBuilder var1);

    protected abstract void setAlleles(IAllele[] var1);

    protected abstract void registerMutations();

    private IAllele[] addVariant(EnumFlowerColor a, EnumFlowerColor b) {
        IAllele[] template = this.getTemplate();
        template[EnumFlowerChromosome.PRIMARY.ordinal()] = a.getFlowerColorAllele();
        template[EnumFlowerChromosome.SECONDARY.ordinal()] = b.getFlowerColorAllele();
        this.variantTemplates.add(template);
        return template;
    }

    private IAllele[] addVariant(EnumFlowerColor a) {
        return this.addVariant(a, a);
    }

    public List<IAllele[]> getVariants() {
        return this.variantTemplates;
    }

    public IClassification getBranch() {
        if (this.branch == null) {
            String scientific = this.branchName.substring(0, 1).toUpperCase() + this.branchName.substring(1).toLowerCase();
            String uid = "flowers." + this.branchName.toLowerCase();
            IClassification branch = AlleleManager.alleleRegistry.getClassification("genus." + uid);
            if (branch == null) {
                branch = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.GENUS, uid, scientific);
            }
            this.branch = branch;
        }
        return this.branch;
    }

    public void setBranch(IClassification branch) {
        this.branch = branch;
    }

    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public IAlleleFlowerSpecies getSpecies() {
        return this.species;
    }

    @Override
    public IFlowerGenome getGenome() {
        return this.genome;
    }

    @Override
    public IFlower getIndividual() {
        return new Flower(this.genome, 0);
    }

    @Override
    public ItemStack getMemberStack(EnumFlowerStage flowerStage) {
        IFlower flower = this.getIndividual();
        return BotanyCore.getFlowerRoot().getMemberStack(flower, flowerStage);
    }

    private void init() {
        FlowerDefinition.markAllelesAsValid((IChromosomeType)EnumBeeChromosome.FERTILITY, EnumFlowerChromosome.FERTILITY);
        FlowerDefinition.markAllelesAsValid((IChromosomeType)EnumBeeChromosome.TERRITORY, EnumFlowerChromosome.TERRITORY);
        FlowerDefinition.markAllelesAsValid((IChromosomeType)EnumBeeChromosome.LIFESPAN, EnumFlowerChromosome.LIFESPAN);
        FlowerDefinition.markAllelesAsValid((IChromosomeType)EnumBeeChromosome.TEMPERATURE_TOLERANCE, EnumFlowerChromosome.TEMPERATURE_TOLERANCE);
        FlowerDefinition.markAllelesAsValid((IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE, EnumFlowerChromosome.HUMIDITY_TOLERANCE);
        FlowerDefinition.markAllelesAsValid((IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE, EnumFlowerChromosome.PH_TOLERANCE);
        FlowerDefinition.markAllelesAsValid((IChromosomeType)EnumTreeChromosome.SAPPINESS, EnumFlowerChromosome.SAPPINESS);
        this.template = Arrays.copyOf(BotanyAPI.flowerRoot.getDefaultTemplate(), EnumFlowerChromosome.values().length);
        AlleleHelper.getInstance().set(this.template, (Enum)EnumFlowerChromosome.SPECIES, (IAllele)this.species);
        AlleleHelper.getInstance().set(this.template, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.getInstance().set(this.template, (Enum)EnumFlowerChromosome.PRIMARY, (IAllele)this.primaryColor.getFlowerColorAllele());
        AlleleHelper.getInstance().set(this.template, (Enum)EnumFlowerChromosome.SECONDARY, (IAllele)this.secondaryColor.getFlowerColorAllele());
        this.setAlleles(this.template);
        this.genome = BotanyCore.getFlowerRoot().templateAsGenome(this.template);
        BotanyCore.getFlowerRoot().registerTemplate(this.template);
        for (IAllele[] template : this.variantTemplates) {
            BotanyCore.getFlowerRoot().registerTemplate(template);
        }
    }

    protected final IFlowerMutationBuilder registerMutation(FlowerDefinition parent1, FlowerDefinition parent2, int chance) {
        return BotanyAPI.flowerFactory.createMutation(parent1.species, parent2.species, this.getTemplate(), chance);
    }

    static {
        VALUES = FlowerDefinition.values();
    }
}

