package binnie.extratrees.alcohol.drink;

import binnie.extratrees.alcohol.Alcohol;
import binnie.extratrees.alcohol.AlcoholEffect;
import binnie.extratrees.alcohol.Glassware;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;

public class ItemDrink extends ItemFood implements IItemModelRegister {
	public ItemDrink() {
		super(0, 0.0f, false);
		this.func_77637_a(Tabs.tabArboriculture);
		this.func_77655_b("drink");
		setRegistryName("drink");
		this.func_77627_a(true);
		this.func_77625_d(1);
		this.func_77848_i();
	}

	public Glassware getGlassware(final ItemStack container) {
		NBTTagCompound nbt = container.func_77978_p();
		if (nbt == null || !nbt.func_74764_b("glassware")) {
			return Glassware.BeerMug;
		}
		return Glassware.values()[nbt.func_74765_d("glassware")];
	}

	public ItemStack getStack(final Glassware glass, @Nullable final FluidStack fluid, int amount) {
		final ItemStack stack = new ItemStack(this, amount);
		this.saveGlassware(glass, stack);
		this.saveFluid(fluid, stack);
		return stack;
	}

	public ItemStack getStack(final Glassware glass, @Nullable final FluidStack fluid) {
		return getStack(glass, fluid, 1);
	}

	public void saveGlassware(final Glassware container, final ItemStack stack) {
		NBTTagCompound nbt = stack.func_77978_p();
		if (nbt == null) {
			nbt = new NBTTagCompound();
			stack.func_77982_d(nbt);
		}
		nbt.func_74777_a("glassware", (short) container.ordinal());
	}

	public void saveFluid(@Nullable final FluidStack fluid, final ItemStack stack) {
		NBTTagCompound nbt = stack.func_77978_p();
		if (nbt == null) {
			nbt = new NBTTagCompound();
			stack.func_77982_d(nbt);
		}

		if (fluid == null) {
			nbt.func_82580_o("fluid");
		} else {
			final NBTTagCompound liq = new NBTTagCompound();
			fluid.writeToNBT(liq);
			nbt.func_74782_a("fluid", liq);
		}
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void registerModel(Item item, IModelManager manager) {
		for (Glassware glassware : Glassware.values()) {
			ModelLoader.registerItemVariants(item, glassware.getLocation());
		}
		manager.registerItemModel(item, (ItemStack stack) -> {
			Glassware glassware = getGlassware(stack);
			return glassware.getLocation();
		});
	}

	@Nullable
	@Override
	public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
		return new FluidHandlerItemGlassware(stack, getGlassware(stack));
	}

	@Override
	public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
		if (this.func_194125_a(tab)) {
			for (final Glassware glassware : Glassware.values()) {
				items.add(this.getStack(glassware, null));
			}
			items.add(this.getStack(Glassware.Wine, Alcohol.RedWine.get(Glassware.Wine.getCapacity())));
		}
	}

	@Override
	public String func_77653_i(final ItemStack stack) {
		final FluidStack fluid = FluidUtil.getFluidContained(stack);
		final IDrinkLiquid liquid;
		if (fluid == null) {
			liquid = null;
		} else {
			liquid = DrinkManager.getLiquid(fluid.getFluid());
		}

		final String liquidName;
		if (liquid == null) {
			liquidName = null;
		} else {
			liquidName = liquid.getName();
		}
		return this.getGlassware(stack).getName(liquidName);
	}

	@Override
	protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
		super.func_77849_c(stack, world, player);
		AlcoholEffect.makeDrunk(player, 2.1f);
	}

	@Override
	public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
		return super.func_77654_b(stack, worldIn, entityLiving);
	}

	@Override
	public EnumAction func_77661_b(final ItemStack itemStack) {
		if (FluidUtil.getFluidContained(itemStack) != null) {
			return EnumAction.DRINK;
		} else {
			return EnumAction.NONE;
		}
	}

	@Override
	public int func_77626_a(final ItemStack p_77626_1_) {
		return 16;
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
		player.func_184598_c(hand);
		return super.func_77659_a(world, player, hand);
	}
}
