package binnie.extrabees.utils;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.commons.lang3.tuple.Pair;

import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

import static org.apache.commons.lang3.ObjectUtils.firstNonNull;

public class AlvearyMutationHandler {

	private static final List<Pair<ItemStack, Float>> MUTATIONS = new ArrayList<>();

	public static boolean isMutationItem(final ItemStack item) {
		return getMutationMult(item) > 1.0f;
	}

	public static float getMutationMult(final ItemStack item) {
		if (!item.func_190926_b()) {
			for (final Pair<ItemStack, Float> comp : MUTATIONS) {
				ItemStack key = comp.getKey();
				if (item.func_77969_a(key) && ItemStack.func_77970_a(item, key)) {
					return comp.getValue();
				}
			}
		}
		return 1.0f;
	}

	public static void addMutationItem(@Nullable Item item, float chance) {
		addMutationItem(new ItemStack(firstNonNull(item, Item.func_150898_a(Blocks.field_150350_a))), chance);
	}

	public static void addMutationItem(final ItemStack item, final float chance) {
		if (item.func_190926_b()) {
			return;
		}
		MUTATIONS.add(Pair.of(item, chance));
		MUTATIONS.sort(Comparator.comparing(Pair::getValue));
	}

	public static List<Pair<ItemStack, Float>> getMutagens() {
		return Collections.unmodifiableList(MUTATIONS);
	}
}
