package binnie.core.machines.storage;

import binnie.Constants;
import binnie.core.util.RecipeUtil;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;

import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

import net.minecraftforge.fml.common.registry.GameRegistry;

import binnie.core.BinnieCore;
import binnie.core.IInitializable;
import binnie.core.machines.MachineGroup;

public class ModuleStorage implements IInitializable {
	@Override
	public void preInit() {
		MachineGroup machineGroup = new MachineGroup(BinnieCore.getInstance(), "storage", "storage", Compartment.values());
		BinnieCore.setPackageCompartment(machineGroup);
		machineGroup.setCreativeTab(CreativeTabs.field_78030_b);
	}

	@Override
	public void init() {
	}

	@Override
	public void postInit() {
		RecipeUtil recipeUtil = new RecipeUtil(Constants.CORE_MOD_ID);
		final String ironGear = OreDictionary.getOres("gearIron").isEmpty() ? "ingotIron" : "gearIron";
		final String goldGear = OreDictionary.getOres("gearGold").isEmpty() ? "ingotGold" : "gearGold";
		final String diamondGear = "gemDiamond";
		recipeUtil.addRecipe("compartment", Compartment.Compartment.get(1), "pcp", "cbc", "pcp", 'b', Items.field_151122_aG, 'c', Blocks.field_150486_ae, 'p', Blocks.field_150430_aB);
		recipeUtil.addRecipe("compartment_copper", Compartment.CompartmentCopper.get(1), "pcp", "cbc", "pcp", 'b', Compartment.Compartment.get(1), 'c', "gearCopper", 'p', Blocks.field_150430_aB);
		recipeUtil.addRecipe("compartment_bronze", Compartment.CompartmentBronze.get(1), "pcp", "cbc", "pcp", 'b', Compartment.CompartmentCopper.get(1), 'c', "gearBronze", 'p', Items.field_151074_bl);
		recipeUtil.addRecipe("compartment_iron", Compartment.CompartmentIron.get(1), "pcp", "cbc", "pcp", 'b', Compartment.CompartmentCopper.get(1), 'c', ironGear, 'p', Items.field_151074_bl);
		recipeUtil.addRecipe("compartment_gold", Compartment.CompartmentGold.get(1), "pcp", "cbc", "pcp", 'b', Compartment.CompartmentIron.get(1), 'c', goldGear, 'p', Items.field_151166_bC);
		recipeUtil.addRecipe("compartment_diamond", Compartment.CompartmentDiamond.get(1), "pcp", "cbc", "pcp", 'b', Compartment.CompartmentGold.get(1), 'c', diamondGear, 'p', Items.field_151166_bC);
	}
}
