/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees;

import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.core.gui.IBinnieGUID;
import binnie.core.models.DoublePassBakedModel;
import binnie.core.network.BinniePacketHandler;
import binnie.core.proxy.IProxyCore;
import binnie.extratrees.alcohol.ModuleAlcohol;
import binnie.extratrees.api.recipes.ExtraTreesRecipeManager;
import binnie.extratrees.block.ModuleBlocks;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.carpentry.ModuleCarpentry;
import binnie.extratrees.config.ConfigurationMain;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.core.ModuleCore;
import binnie.extratrees.genetics.ETTreeDefinition;
import binnie.extratrees.genetics.FruitSprite;
import binnie.extratrees.genetics.ModuleGenetics;
import binnie.extratrees.integration.crafttweaker.CraftTweakerModule;
import binnie.extratrees.item.ModuleItems;
import binnie.extratrees.kitchen.ModuleKitchen;
import binnie.extratrees.machines.DummyManagers;
import binnie.extratrees.machines.ModuleMachine;
import binnie.extratrees.machines.brewery.recipes.BreweryRecipeManager;
import binnie.extratrees.machines.distillery.recipes.DistilleryRecipeManager;
import binnie.extratrees.machines.fruitpress.recipes.FruitPressRecipeManager;
import binnie.extratrees.machines.lumbermill.recipes.LumbermillRecipeManager;
import binnie.extratrees.proxy.Proxy;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="extratrees", name="Binnie's Extra Trees", dependencies="required-after:binniecore", acceptedMinecraftVersions="[1.12]")
public class ExtraTrees
extends AbstractMod {
    @Mod.Instance(value="extratrees")
    public static ExtraTrees instance;
    @SidedProxy(clientSide="binnie.extratrees.proxy.ProxyClient", serverSide="binnie.extratrees.proxy.ProxyServer")
    public static Proxy proxy;
    @Nullable
    private static ModuleBlocks blocks;
    @Nullable
    private static ModuleItems items;
    @Nullable
    private static ModuleAlcohol alcohol;
    @Nullable
    private static ModuleCarpentry carpentry;
    @Nullable
    private static ModuleMachine machine;
    @Nullable
    private static ModuleKitchen kitchen;

    public ExtraTrees() {
        MinecraftForge.EVENT_BUS.register(ModuleGenetics.class);
    }

    public static ModuleItems items() {
        Preconditions.checkState((items != null ? 1 : 0) != 0);
        return items;
    }

    public static ModuleBlocks blocks() {
        Preconditions.checkState((blocks != null ? 1 : 0) != 0);
        return blocks;
    }

    public static ModuleAlcohol alcohol() {
        Preconditions.checkState((alcohol != null ? 1 : 0) != 0);
        return alcohol;
    }

    public static ModuleCarpentry carpentry() {
        Preconditions.checkState((carpentry != null ? 1 : 0) != 0);
        return carpentry;
    }

    public static ModuleMachine machine() {
        Preconditions.checkState((machine != null ? 1 : 0) != 0);
        return machine;
    }

    public static ModuleKitchen getKitchen() {
        Preconditions.checkState((kitchen != null ? 1 : 0) != 0);
        return kitchen;
    }

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        this.postInit();
    }

    @Override
    protected void registerModules() {
        blocks = new ModuleBlocks();
        this.addModule(blocks);
        items = new ModuleItems();
        this.addModule(items);
        alcohol = new ModuleAlcohol();
        this.addModule(alcohol);
        this.addModule(new ModuleGenetics());
        carpentry = new ModuleCarpentry();
        this.addModule(carpentry);
        machine = new ModuleMachine();
        this.addModule(machine);
        this.addModule(new ModuleCore());
        kitchen = new ModuleKitchen();
        this.addModule(kitchen);
        this.addModule(new CraftTweakerModule());
    }

    @Override
    public void setupAPI() {
        ExtraTreesRecipeManager.breweryManager = new BreweryRecipeManager();
        ExtraTreesRecipeManager.lumbermillManager = new LumbermillRecipeManager();
        ExtraTreesRecipeManager.fruitPressManager = new FruitPressRecipeManager();
        ExtraTreesRecipeManager.distilleryManager = new DistilleryRecipeManager();
    }

    @Override
    public void disabledSetupAPI() {
        ExtraTreesRecipeManager.breweryManager = new DummyManagers.DummyBreweryManager();
        ExtraTreesRecipeManager.lumbermillManager = new DummyManagers.DummyLumbermillManager();
        ExtraTreesRecipeManager.fruitPressManager = new DummyManagers.DummyFruitPressManager();
        ExtraTreesRecipeManager.distilleryManager = new DummyManagers.DummyDistilleryManager();
    }

    @Override
    public IBinnieGUID[] getGUIDs() {
        return ExtraTreesGUID.values();
    }

    @Override
    public Class<?>[] getConfigs() {
        return new Class[]{ConfigurationMain.class};
    }

    @Override
    public String getChannel() {
        return "ET";
    }

    @Override
    public IProxyCore getProxy() {
        return proxy;
    }

    @Override
    public String getModID() {
        return "extratrees";
    }

    @Override
    protected Class<? extends BinniePacketHandler> getPacketHandler() {
        return PacketHandler.class;
    }

    @Override
    public boolean isAvailable() {
        return BinnieCore.isExtraTreesActive();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBakedEvent(ModelBakeEvent e) {
        List<ModelResourceLocation> models = e.getModelRegistry().func_148742_b().stream().filter(mrl -> mrl.func_110624_b().startsWith("extratrees")).filter(mrl -> mrl.func_110623_a().startsWith("germlings")).collect(Collectors.toList());
        Map<String, ETTreeDefinition> map = Arrays.stream(ETTreeDefinition.values()).collect(Collectors.toMap(o -> o.name().toLowerCase(), o -> o));
        models.forEach(model -> {
            String species = model.func_177518_c().split("=")[1];
            ETTreeDefinition treeSpecies = (ETTreeDefinition)((Object)((Object)map.get(species)));
            int primaryColor = treeSpecies.getLeafColor().getRGB();
            int secondaryColor = treeSpecies.getWoodColor().getRGB();
            e.getModelRegistry().func_82595_a(model, (Object)new DoublePassBakedModel((IBakedModel)e.getModelRegistry().func_82594_a(model), primaryColor, secondaryColor));
        });
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(TextureStitchEvent.Pre event) {
        for (FruitSprite sprite : FruitSprite.VALUES) {
            sprite.registerSprites();
        }
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        for (PlankType.ExtraTreePlanks extraTreePlanks : PlankType.ExtraTreePlanks.VALUES) {
            extraTreePlanks.registerSprites(map);
        }
        for (Enum enum_ : PlankType.ForestryPlanks.values()) {
            enum_.registerSprites(map);
        }
        for (Enum enum_ : PlankType.VanillaPlanks.values()) {
            enum_.registerSprites(map);
        }
    }

    public static class PacketHandler
    extends BinniePacketHandler {
        public PacketHandler() {
            super(instance);
        }
    }
}

