/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.Binnie;
import binnie.core.genetics.IItemStackRepresentitive;
import binnie.core.resource.BinnieSprite;
import binnie.core.util.I18N;
import com.mojang.authlib.GameProfile;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BreedingSystem
implements IItemStackRepresentitive {
    public float discoveredSpeciesPercentage;
    public int totalSpeciesCount;
    public int discoveredSpeciesCount;
    public int totalSecretCount;
    public int discoveredSecretCount;
    public float discoveredBranchPercentage;
    public int totalBranchCount;
    public int discoveredBranchCount;
    protected BinnieSprite iconUndiscovered;
    protected BinnieSprite iconDiscovered;
    List<IAlleleSpecies> allActiveSpecies;
    String currentEpithet;
    private List<IClassification> allBranches = new ArrayList<IClassification>();
    private List<IAlleleSpecies> allSpecies;
    private List<IMutation> allMutations;
    private Map<IAlleleSpecies, List<IMutation>> resultantMutations;
    private Map<IAlleleSpecies, List<IMutation>> furtherMutations;
    private Map<IAlleleSpecies, List<IMutation>> allResultantMutations;
    private Map<IAlleleSpecies, List<IMutation>> allFurtherMutations;
    private int totalSecretBranchCount;
    private int discoveredSecretBranchCount;

    public BreedingSystem() {
        this.allActiveSpecies = new ArrayList<IAlleleSpecies>();
        this.allSpecies = new ArrayList<IAlleleSpecies>();
        this.allMutations = new ArrayList<IMutation>();
        this.resultantMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.furtherMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.allResultantMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.allFurtherMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        Binnie.GENETICS.registerBreedingSystem(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String getChromosomeName(IChromosomeType chromo) {
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".chromosome." + chromo.getName());
    }

    public String getChromosomeShortName(IChromosomeType chromo) {
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".chromosome." + chromo.getName() + ".short");
    }

    public final String getEpitome(float discoveredPercentage) {
        int i = 0;
        if (discoveredPercentage == 1.0f) {
            i = 6;
        } else if (discoveredPercentage < 0.1f) {
            i = 0;
        } else if (discoveredPercentage < 0.3f) {
            i = 1;
        } else if (discoveredPercentage < 0.5f) {
            i = 2;
        } else if (discoveredPercentage < 0.7f) {
            i = 3;
        } else if (discoveredPercentage < 0.9f) {
            i = 4;
        } else if (discoveredPercentage < 1.0f) {
            i = 5;
        }
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".epitome." + i);
    }

    public abstract ISpeciesRoot getSpeciesRoot();

    public final List<IClassification> getAllBranches() {
        return this.allBranches;
    }

    public final Collection<IAlleleSpecies> getAllSpecies() {
        return this.allActiveSpecies;
    }

    public final Collection<IMutation> getAllMutations() {
        return this.allMutations;
    }

    public void calculateArrays() {
        ISpeciesRoot speciesRoot = this.getSpeciesRoot();
        this.calculateAlleles(speciesRoot);
        this.calculateBranches(speciesRoot);
        this.calculateMutations(speciesRoot);
    }

    public void calculateAlleles(ISpeciesRoot speciesRoot) {
        this.allSpecies = new ArrayList<IAlleleSpecies>();
        this.allActiveSpecies = new ArrayList<IAlleleSpecies>();
        this.resultantMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.furtherMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.allResultantMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.allFurtherMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        Collection allAlleles = AlleleManager.alleleRegistry.getRegisteredAlleles().values();
        for (IAllele allele : allAlleles) {
            String uid = allele.getUID();
            IAllele[] template = speciesRoot.getTemplate(uid);
            if (template == null) continue;
            IAlleleSpecies species = (IAlleleSpecies)allele;
            this.resultantMutations.put(species, new ArrayList());
            this.furtherMutations.put(species, new ArrayList());
            this.allResultantMutations.put(species, new ArrayList());
            this.allFurtherMutations.put(species, new ArrayList());
            this.allSpecies.add(species);
            if (this.isBlacklisted(allele) || uid.contains("speciesBotAlfheim")) continue;
            this.allActiveSpecies.add((IAlleleSpecies)allele);
        }
    }

    public void calculateBranches(ISpeciesRoot speciesRoot) {
        Collection allRegBranches = AlleleManager.alleleRegistry.getRegisteredClassifications().values();
        this.allBranches = new ArrayList<IClassification>();
        for (IClassification branch : allRegBranches) {
            IAlleleSpecies firstSpecies;
            IAllele[] template;
            IAlleleSpecies[] species = branch.getMemberSpecies();
            if (species.length <= 0 || (template = speciesRoot.getTemplate((firstSpecies = species[0]).getUID())) == null) continue;
            boolean possible = false;
            for (IAlleleSpecies species2 : branch.getMemberSpecies()) {
                if (!this.allActiveSpecies.contains(species2)) continue;
                possible = true;
            }
            if (!possible) continue;
            this.allBranches.add(branch);
        }
    }

    public void calculateMutations(ISpeciesRoot speciesRoot) {
        this.allMutations = new ArrayList<IMutation>();
        List speciesMutations = speciesRoot.getMutations(false);
        if (!speciesMutations.isEmpty()) {
            LinkedHashSet mutations = new LinkedHashSet();
            mutations.addAll(speciesMutations);
            for (IMutation mutation : mutations) {
                this.allMutations.add(mutation);
                LinkedHashSet<IAlleleSpecies> participatingSpecies = new LinkedHashSet<IAlleleSpecies>();
                participatingSpecies.add(mutation.getAllele0());
                participatingSpecies.add(mutation.getAllele1());
                for (IAlleleSpecies species : participatingSpecies) {
                    this.allFurtherMutations.get(species).add(mutation);
                    if (!this.allActiveSpecies.contains(species)) continue;
                    this.furtherMutations.get(species).add(mutation);
                }
                IAllele[] template = mutation.getTemplate();
                IAlleleSpecies speciesAllele = (IAlleleSpecies)template[0];
                if (!this.resultantMutations.containsKey(speciesAllele)) continue;
                this.allResultantMutations.get(speciesAllele).add(mutation);
                this.resultantMutations.get(speciesAllele).add(mutation);
            }
        }
    }

    public final boolean isBlacklisted(IAllele allele) {
        return AlleleManager.alleleRegistry.isBlacklisted(allele.getUID());
    }

    public final List<IMutation> getResultantMutations(IAlleleSpecies species, boolean includeInactive) {
        if (this.resultantMutations.isEmpty()) {
            this.calculateArrays();
        }
        return includeInactive ? this.allResultantMutations.get(species) : this.resultantMutations.get(species);
    }

    public final List<IMutation> getResultantMutations(IAlleleSpecies species) {
        if (this.resultantMutations.isEmpty()) {
            this.calculateArrays();
        }
        return this.resultantMutations.get(species);
    }

    public final List<IMutation> getFurtherMutations(IAlleleSpecies species, boolean includeInactive) {
        if (this.furtherMutations.isEmpty()) {
            this.calculateArrays();
        }
        return includeInactive ? this.allFurtherMutations.get(species) : this.furtherMutations.get(species);
    }

    public final List<IMutation> getFurtherMutations(IAlleleSpecies species) {
        if (this.furtherMutations.isEmpty()) {
            this.calculateArrays();
        }
        return this.furtherMutations.get(species);
    }

    public final boolean isMutationDiscovered(IMutation mutation, World world, GameProfile name) {
        return this.isMutationDiscovered(mutation, this.getSpeciesRoot().getBreedingTracker(world, name));
    }

    public final boolean isMutationDiscovered(IMutation mutation, IBreedingTracker tracker) {
        return tracker.isDiscovered(mutation);
    }

    public final boolean isSpeciesDiscovered(IAlleleSpecies species, World world, GameProfile name) {
        return this.isSpeciesDiscovered(species, this.getSpeciesRoot().getBreedingTracker(world, name));
    }

    public final boolean isSpeciesDiscovered(IAlleleSpecies species, IBreedingTracker tracker) {
        return tracker.isDiscovered(species);
    }

    public final boolean isSecret(IAlleleSpecies species) {
        return !species.isCounted();
    }

    public final boolean isSecret(IClassification branch) {
        for (IAlleleSpecies species : branch.getMemberSpecies()) {
            if (this.isSecret(species)) continue;
            return false;
        }
        return true;
    }

    public final Collection<IClassification> getDiscoveredBranches(World world, GameProfile player) {
        ArrayList<IClassification> branches = new ArrayList<IClassification>();
        for (IClassification branch : this.getAllBranches()) {
            boolean discovered = false;
            for (IAlleleSpecies species : branch.getMemberSpecies()) {
                if (!this.isSpeciesDiscovered(species, world, player)) continue;
                discovered = true;
            }
            if (!discovered) continue;
            branches.add(branch);
        }
        return branches;
    }

    public final Collection<IClassification> getDiscoveredBranches(IBreedingTracker tracker) {
        ArrayList<IClassification> branches = new ArrayList<IClassification>();
        for (IClassification branch : this.getAllBranches()) {
            boolean discovered = false;
            for (IAlleleSpecies species : branch.getMemberSpecies()) {
                if (!this.isSpeciesDiscovered(species, tracker)) continue;
                discovered = true;
            }
            if (!discovered) continue;
            branches.add(branch);
        }
        return branches;
    }

    public final Collection<IAlleleSpecies> getDiscoveredSpecies(World world, GameProfile player) {
        ArrayList<IAlleleSpecies> speciesList = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : this.getAllSpecies()) {
            if (!this.isSpeciesDiscovered(species, world, player)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public final Collection<IAlleleSpecies> getDiscoveredSpecies(IBreedingTracker tracker) {
        ArrayList<IAlleleSpecies> speciesList = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : this.getAllSpecies()) {
            if (!this.isSpeciesDiscovered(species, tracker)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public final List<IMutation> getDiscoveredMutations(World world, GameProfile player) {
        ArrayList<IMutation> speciesList = new ArrayList<IMutation>();
        for (IMutation species : this.getAllMutations()) {
            if (!this.isMutationDiscovered(species, world, player)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public final List<IMutation> getDiscoveredMutations(IBreedingTracker tracker) {
        ArrayList<IMutation> speciesList = new ArrayList<IMutation>();
        for (IMutation species : this.getAllMutations()) {
            if (!this.isMutationDiscovered(species, tracker)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public final int getDiscoveredBranchMembers(IClassification branch, IBreedingTracker tracker) {
        int discoveredSpecies = 0;
        for (IAlleleSpecies species : branch.getMemberSpecies()) {
            if (!this.isSpeciesDiscovered(species, tracker)) continue;
            ++discoveredSpecies;
        }
        return discoveredSpecies;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getUndiscoveredIcon() {
        return this.iconUndiscovered.getSprite();
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getDiscoveredIcon() {
        return this.iconDiscovered.getSprite();
    }

    public abstract float getChance(IMutation var1, EntityPlayer var2, IAlleleSpecies var3, IAlleleSpecies var4);

    public abstract Class<? extends IBreedingTracker> getTrackerClass();

    @SubscribeEvent
    public final void onSyncBreedingTracker(ForestryEvent.SyncedBreedingTracker event) {
        IBreedingTracker tracker = event.tracker;
        if (!this.getTrackerClass().isInstance(tracker)) {
            return;
        }
        this.syncTracker(tracker);
    }

    public final void syncTracker(IBreedingTracker tracker) {
        if (this.allActiveSpecies.isEmpty()) {
            this.calculateArrays();
        }
        this.discoveredSpeciesPercentage = 0.0f;
        this.totalSpeciesCount = 0;
        this.discoveredSpeciesCount = 0;
        this.totalSecretCount = 0;
        this.discoveredSecretCount = 0;
        Collection<IAlleleSpecies> discoveredSpecies = this.getDiscoveredSpecies(tracker);
        Collection<IAlleleSpecies> allSpecies = this.getAllSpecies();
        for (IAlleleSpecies species : allSpecies) {
            if (!this.isSecret(species)) {
                ++this.totalSpeciesCount;
                if (!this.isSpeciesDiscovered(species, tracker)) continue;
                ++this.discoveredSpeciesCount;
                continue;
            }
            ++this.totalSecretCount;
            if (!this.isSpeciesDiscovered(species, tracker)) continue;
            ++this.discoveredSecretCount;
        }
        this.discoveredBranchPercentage = 0.0f;
        this.totalBranchCount = 0;
        this.discoveredBranchCount = 0;
        Collection<IClassification> discoveredBranches = this.getDiscoveredBranches(tracker);
        List<IClassification> allBranches = this.getAllBranches();
        for (IClassification branch : allBranches) {
            if (!this.isSecret(branch)) {
                ++this.totalBranchCount;
                if (!discoveredBranches.contains(branch)) continue;
                ++this.discoveredBranchCount;
                continue;
            }
            ++this.totalSecretBranchCount;
            if (!discoveredBranches.contains(branch)) continue;
            ++this.discoveredSecretBranchCount;
        }
        this.discoveredSpeciesPercentage = this.discoveredSpeciesCount / this.totalSpeciesCount;
        this.discoveredBranchPercentage = this.discoveredBranchCount / this.totalBranchCount;
        String epithet = this.getEpitome();
        this.onSyncBreedingTracker(tracker);
    }

    public void onSyncBreedingTracker(IBreedingTracker tracker) {
    }

    public String getEpitome() {
        return this.getEpitome(this.discoveredSpeciesPercentage);
    }

    public final String getDescriptor() {
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".descriptor");
    }

    public final String getIdent() {
        return this.getSpeciesRoot().getUID();
    }

    @Nullable
    public final IChromosomeType getChromosome(int index) {
        for (IChromosomeType chromosome : this.getSpeciesRoot().getKaryotype()) {
            if (index != chromosome.ordinal()) continue;
            return chromosome;
        }
        return null;
    }

    public abstract int getColour();

    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (allele instanceof IAlleleBoolean) {
            IAlleleBoolean alleleBoolean = (IAlleleBoolean)allele;
            return alleleBoolean.getValue() ? I18N.localise("binniecore.allele.true") : I18N.localise("binniecore.allele.false");
        }
        if (Objects.equals(allele.getAlleleName(), "for.gui.maximum")) {
            return I18N.localise("binniecore.allele.fertility.maximum");
        }
        return allele.getAlleleName();
    }

    public String getName() {
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".shortName");
    }

    @Override
    public ItemStack getItemStackRepresentitive() {
        IIndividual first = (IIndividual)this.getSpeciesRoot().getIndividualTemplates().get(0);
        return this.getSpeciesRoot().getMemberStack(first, this.getDefaultType());
    }

    public String toString() {
        return this.getName();
    }

    public abstract boolean isDNAManipulable(ItemStack var1);

    public abstract boolean isDNAManipulable(ISpeciesType var1);

    @Nullable
    public IIndividual getConversion(ItemStack stack) {
        return null;
    }

    public final IIndividual getDefaultIndividual() {
        return this.getSpeciesRoot().templateAsIndividual(this.getSpeciesRoot().getDefaultTemplate());
    }

    public final ISpeciesType getDefaultType() {
        return this.getActiveTypes()[0];
    }

    public abstract ISpeciesType[] getActiveTypes();

    public abstract void addExtraAlleles(IChromosomeType var1, TreeSet<IAllele> var2);

    public ItemStack getConversionStack(ItemStack stack) {
        IIndividual conversion = this.getConversion(stack);
        if (conversion == null) {
            return ItemStack.field_190927_a;
        }
        return this.getSpeciesRoot().getMemberStack(conversion, this.getDefaultType());
    }

    public final Collection<IChromosomeType> getActiveKaryotype() {
        return Binnie.GENETICS.getActiveChromosomes(this.getSpeciesRoot());
    }

    public ItemStack getDefaultMember(String uid) {
        IIndividual individual = this.getIndividual(uid);
        if (individual == null) {
            return ItemStack.field_190927_a;
        }
        return this.getSpeciesRoot().getMemberStack(individual, this.getDefaultType());
    }

    @Nullable
    public IIndividual getIndividual(String uid) {
        IAllele[] template = this.getSpeciesRoot().getTemplate(uid);
        if (template == null) {
            return null;
        }
        return this.getSpeciesRoot().templateAsIndividual(template);
    }

    @Nullable
    public IGenome getGenome(String uid) {
        IAllele[] template = this.getSpeciesRoot().getTemplate(uid);
        if (template == null) {
            return null;
        }
        return this.getSpeciesRoot().templateAsGenome(template);
    }
}

