/*
 * Decompiled with CFR 0.152.
 */
package binnie.core;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.ManagerBase;
import binnie.core.block.TileEntityMetadata;
import binnie.core.gui.BinnieCoreGUI;
import binnie.core.gui.BinnieGUIHandler;
import binnie.core.gui.IBinnieGUID;
import binnie.core.gui.minecraft.ModuleCraftGUI;
import binnie.core.integration.extrabees.ExtraBeesIntegration;
import binnie.core.item.ItemFieldKit;
import binnie.core.item.ItemGenesis;
import binnie.core.item.ModuleItems;
import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.ItemFluidContainer;
import binnie.core.machines.MachineGroup;
import binnie.core.machines.storage.ModuleStorage;
import binnie.core.mod.config.ConfigurationMain;
import binnie.core.mod.config.ConfigurationMods;
import binnie.core.models.ModelManager;
import binnie.core.network.BinnieCorePacketID;
import binnie.core.network.BinniePacketHandler;
import binnie.core.network.IPacketID;
import binnie.core.proxy.BinnieProxy;
import binnie.core.proxy.IBinnieProxy;
import binnie.core.triggers.ModuleTrigger;
import binnie.modules.ModuleManager;
import com.google.common.base.Preconditions;
import forestry.arboriculture.PluginArboriculture;
import forestry.lepidopterology.PluginLepidopterology;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="binniecore", name="Binnie Core", version="2.2.0.4", dependencies="required-after:forge@[13.20.0.2279,);required-after:forestry@[5.3.4.102,);after:jei@[4.3.1,);", acceptedMinecraftVersions="[1.12]")
public final class BinnieCore
extends AbstractMod {
    private static final List<AbstractMod> modList = new ArrayList<AbstractMod>();
    public static int multipassRenderID;
    @Mod.Instance(value="binniecore")
    private static BinnieCore instance;
    @SidedProxy(clientSide="binnie.core.proxy.BinnieProxyClient", serverSide="binnie.core.proxy.BinnieProxyServer")
    private static BinnieProxy proxy;
    @Nullable
    private static MachineGroup packageCompartment;
    @Nullable
    private static ItemGenesis genesis;
    @Nullable
    private static ItemFieldKit fieldKit;

    public BinnieCore() {
        FluidRegistry.enableUniversalBucket();
    }

    public static MachineGroup getPackageCompartment() {
        Preconditions.checkState((packageCompartment != null ? 1 : 0) != 0, (Object)"packageCompartment has not been init");
        return packageCompartment;
    }

    public static void setPackageCompartment(MachineGroup packageCompartment) {
        BinnieCore.packageCompartment = packageCompartment;
    }

    public static ItemGenesis getGenesis() {
        Preconditions.checkState((genesis != null ? 1 : 0) != 0, (Object)"genesis has not been init");
        return genesis;
    }

    public static void setGenesis(ItemGenesis genesis) {
        BinnieCore.genesis = genesis;
    }

    public static ItemFieldKit getFieldKit() {
        Preconditions.checkState((fieldKit != null ? 1 : 0) != 0, (Object)"fieldKit has not been init");
        return fieldKit;
    }

    public static void setFieldKit(ItemFieldKit fieldKit) {
        BinnieCore.fieldKit = fieldKit;
    }

    public static BinnieCore getInstance() {
        return instance;
    }

    public static BinnieProxy getBinnieProxy() {
        return proxy;
    }

    public static boolean isLepidopteryActive() {
        return PluginManager.configDisabledPlugins.stream().noneMatch(e -> e instanceof PluginLepidopterology);
    }

    public static boolean isApicultureActive() {
        return PluginManager.configDisabledPlugins.stream().noneMatch(e -> e instanceof PluginArboriculture);
    }

    public static boolean isArboricultureActive() {
        return PluginManager.configDisabledPlugins.stream().noneMatch(e -> e instanceof PluginArboriculture);
    }

    public static boolean isBotanyActive() {
        return ConfigurationMods.botany;
    }

    public static boolean isGeneticsActive() {
        return ConfigurationMods.genetics;
    }

    public static boolean isExtraBeesActive() {
        return ExtraBeesIntegration.isLoaded() && BinnieCore.isApicultureActive();
    }

    public static boolean isExtraTreesActive() {
        return ConfigurationMods.extraTrees && BinnieCore.isArboricultureActive();
    }

    static void registerMod(AbstractMod mod) {
        modList.add(mod);
    }

    private static List<AbstractMod> getActiveMods() {
        ArrayList<AbstractMod> list = new ArrayList<AbstractMod>();
        for (AbstractMod mod : modList) {
            if (!mod.isAvailable()) continue;
            list.add(mod);
        }
        return list;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        ModuleManager.loadModules(evt);
        MinecraftForge.EVENT_BUS.register((Object)Binnie.LIQUID);
        Binnie.CONFIGURATION.registerConfiguration(ConfigurationMods.class, this);
        for (FluidContainerType container : FluidContainerType.getBinnieContainers()) {
            ItemFluidContainer item = new ItemFluidContainer(container);
            this.getProxy().registerItem((Item)item);
        }
        this.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.init();
        for (AbstractMod mod : BinnieCore.getActiveMods()) {
            NetworkRegistry.INSTANCE.registerGuiHandler(mod.getMod(), (IGuiHandler)new BinnieGUIHandler(mod));
        }
        GameRegistry.registerTileEntity(TileEntityMetadata.class, (String)"binnie.tile.metadata");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        this.postInit();
    }

    @Override
    protected void registerModules() {
        for (ManagerBase baseManager : Binnie.MANAGERS) {
            this.addModule(baseManager);
        }
        this.addModule(new ModuleCraftGUI());
        this.addModule(new ModuleStorage());
        this.addModule(new ModuleItems());
        if (Loader.isModLoaded((String)"BuildCraft|Silicon")) {
            this.addModule(new ModuleTrigger());
        }
        if (ExtraBeesIntegration.isLoaded()) {
            this.addModule(new ExtraBeesIntegration());
        }
    }

    @Override
    public IBinnieGUID[] getGUIDs() {
        return BinnieCoreGUI.values();
    }

    @Override
    public String getChannel() {
        return "BIN";
    }

    @Override
    public IBinnieProxy getProxy() {
        return proxy;
    }

    @Override
    public String getModID() {
        return "binniecore";
    }

    @Override
    public IPacketID[] getPacketIDs() {
        return BinnieCorePacketID.values();
    }

    @Override
    public Class<?>[] getConfigs() {
        return new Class[]{ConfigurationMain.class};
    }

    @Override
    protected Class<? extends BinniePacketHandler> getPacketHandler() {
        return PacketHandler.class;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleTextureRemap(TextureStitchEvent.Pre event) {
        Binnie.RESOURCE.registerSprites();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleModelBake(ModelBakeEvent event) {
        ModelManager.registerCustomModels(event);
    }

    public static class PacketHandler
    extends BinniePacketHandler {
        public PacketHandler() {
            super(BinnieCore.getInstance());
        }
    }
}

